/*
 * Decompiled with CFR 0.152.
 */
package oidc.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.servlet.Filter;
import oidc.config.AppConfig;
import oidc.repository.AuthenticationRequestRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.repository.UserRepository;
import oidc.secure.LoggingStrictHttpFirewall;
import oidc.user.SamlProvisioningAuthenticationManager;
import oidc.web.ConcurrentSavedRequestAwareAuthenticationSuccessHandler;
import oidc.web.ConfigurableSamlAuthenticationRequestFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.saml.SamlRequestMatcher;
import org.springframework.security.saml.SamlValidator;
import org.springframework.security.saml.provider.SamlServerConfiguration;
import org.springframework.security.saml.provider.provisioning.SamlProviderProvisioning;
import org.springframework.security.saml.provider.service.authentication.SamlAuthenticationResponseFilter;
import org.springframework.security.saml.provider.service.config.SamlServiceProviderServerBeanConfiguration;
import org.springframework.security.saml.spi.DefaultValidator;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.firewall.StrictHttpFirewall;

@Configuration
@EnableScheduling
public class BeanConfig
extends SamlServiceProviderServerBeanConfiguration {
    private AppConfig appConfiguration;
    private UserRepository userRepository;
    private AuthenticationRequestRepository authenticationRequestRepository;
    private OpenIDClientRepository openIDClientRepository;
    private ObjectMapper objectMapper;

    public BeanConfig(AppConfig config, UserRepository userRepository, AuthenticationRequestRepository authenticationRequestRepository, OpenIDClientRepository openIDClientRepository, ObjectMapper objectMapper) {
        this.appConfiguration = config;
        this.userRepository = userRepository;
        this.openIDClientRepository = openIDClientRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.objectMapper = objectMapper;
    }

    protected SamlServerConfiguration getDefaultHostSamlServerConfiguration() {
        return this.appConfiguration;
    }

    @Bean
    public Filter spSelectIdentityProviderFilter() {
        return (request, response, chain) -> chain.doFilter(request, response);
    }

    @Bean
    public SamlValidator samlValidator() {
        DefaultValidator defaultValidator = (DefaultValidator)super.samlValidator();
        defaultValidator.setMaxAuthenticationAgeMillis(1471228928);
        defaultValidator.setResponseSkewTimeMillis(600000);
        return defaultValidator;
    }

    @Bean
    public Filter spAuthenticationRequestFilter() {
        SamlProviderProvisioning provisioning = this.getSamlProvisioning();
        SamlRequestMatcher requestMatcher = new SamlRequestMatcher(provisioning, "authorize", false);
        return new ConfigurableSamlAuthenticationRequestFilter(provisioning, requestMatcher, this.authenticationRequestRepository, this.openIDClientRepository);
    }

    @Bean
    public SamlProvisioningAuthenticationManager samlProvisioningAuthenticationManager() throws IOException {
        return new SamlProvisioningAuthenticationManager(this.userRepository, this.objectMapper);
    }

    @Bean
    public StrictHttpFirewall strictHttpFirewall() {
        return new LoggingStrictHttpFirewall();
    }

    @Bean
    public Filter spAuthenticationResponseFilter() {
        SamlAuthenticationResponseFilter filter = (SamlAuthenticationResponseFilter)super.spAuthenticationResponseFilter();
        try {
            filter.setAuthenticationManager((AuthenticationManager)this.samlProvisioningAuthenticationManager());
            filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new ConcurrentSavedRequestAwareAuthenticationSuccessHandler(this.authenticationRequestRepository));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return filter;
    }
}

