/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import oidc.endpoints.OidcEndpoint;
import oidc.exceptions.InvalidGrantException;
import oidc.exceptions.InvalidScopeException;
import oidc.exceptions.RedirectMismatchException;
import oidc.exceptions.UnsupportedPromptValueException;
import oidc.model.AccessToken;
import oidc.model.AuthorizationCode;
import oidc.model.OpenIDClient;
import oidc.model.ProvidedRedirectURI;
import oidc.model.User;
import oidc.repository.AccessTokenRepository;
import oidc.repository.AuthorizationCodeRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.repository.RefreshTokenRepository;
import oidc.repository.UserRepository;
import oidc.secure.JWTRequest;
import oidc.secure.TokenGenerator;
import oidc.user.OidcSamlAuthentication;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class AuthorizationEndpoint
implements OidcEndpoint {
    private static final Log LOG = LogFactory.getLog(AuthorizationEndpoint.class);
    private static List<String> forFreeOpenIDScopes = Arrays.asList("profile", "email", "address", "phone");
    private TokenGenerator tokenGenerator;
    private AuthorizationCodeRepository authorizationCodeRepository;
    private AccessTokenRepository accessTokenRepository;
    private UserRepository userRepository;
    private RefreshTokenRepository refreshTokenRepository;
    private OpenIDClientRepository openIDClientRepository;
    private static final String unsupportedPromptMessage = "Unsupported Prompt value";

    @Autowired
    public AuthorizationEndpoint(AuthorizationCodeRepository authorizationCodeRepository, AccessTokenRepository accessTokenRepository, RefreshTokenRepository refreshTokenRepository, UserRepository userRepository, OpenIDClientRepository openIDClientRepository, TokenGenerator tokenGenerator) {
        this.authorizationCodeRepository = authorizationCodeRepository;
        this.accessTokenRepository = accessTokenRepository;
        this.refreshTokenRepository = refreshTokenRepository;
        this.userRepository = userRepository;
        this.openIDClientRepository = openIDClientRepository;
        this.tokenGenerator = tokenGenerator;
    }

    @GetMapping(value={"/oidc/authorize"})
    public ModelAndView authorize(@RequestParam MultiValueMap<String, String> parameters, Authentication authentication) throws com.nimbusds.oauth2.sdk.ParseException, JOSEException, IOException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, BadJOSEException, ParseException, URISyntaxException {
        LOG.info((Object)String.format("/oidc/authorize %s %s", authentication.getDetails(), parameters));
        this.logout();
        OidcSamlAuthentication samlAuthentication = (OidcSamlAuthentication)authentication;
        AuthorizationRequest authenticationRequest = AuthorizationRequest.parse(parameters);
        Scope scope = authenticationRequest.getScope();
        boolean isOpenIdClient = scope != null && this.isOpenIDRequest(scope.toStringList());
        OpenIDClient client = this.openIDClientRepository.findByClientId(authenticationRequest.getClientID().getValue());
        if (isOpenIdClient) {
            AuthenticationRequest oidcAuthenticationRequest = AuthenticationRequest.parse(parameters);
            if (oidcAuthenticationRequest.specifiesRequestObject()) {
                oidcAuthenticationRequest = JWTRequest.parse((AuthenticationRequest)oidcAuthenticationRequest, (OpenIDClient)client);
                LOG.debug((Object)"/oidc/authorize with JWT 'request'");
            }
            authenticationRequest = oidcAuthenticationRequest;
        }
        State state = authenticationRequest.getState();
        String redirectURI = AuthorizationEndpoint.validateRedirectionURI((AuthorizationRequest)authenticationRequest, (OpenIDClient)client).getRedirectURI();
        List scopes = AuthorizationEndpoint.validateScopes((AuthorizationRequest)authenticationRequest, (OpenIDClient)client);
        ResponseType responseType = AuthorizationEndpoint.validateGrantType((AuthorizationRequest)authenticationRequest, (OpenIDClient)client);
        User user = samlAuthentication.getUser();
        ResponseMode responseMode = authenticationRequest.impliedResponseMode();
        if (responseType.impliesCodeFlow()) {
            AuthorizationCode authorizationCode = this.createAndSaveAuthorizationCode(authenticationRequest, client, user);
            LOG.info((Object)String.format("Returning authorizationCode flow %s %s", ResponseMode.FORM_POST, redirectURI));
            if (responseMode.equals((Object)ResponseMode.FORM_POST)) {
                HashMap<String, String> body = new HashMap<String, String>();
                body.put("redirect_uri", redirectURI);
                body.put("code", authorizationCode.getCode());
                if (state != null && StringUtils.hasText((String)state.getValue())) {
                    body.put("state", state.getValue());
                }
                return new ModelAndView("form_post", body);
            }
            return new ModelAndView((View)new RedirectView(this.authorizationRedirect(redirectURI, state, authorizationCode.getCode(), responseMode.equals((Object)ResponseMode.FRAGMENT))));
        }
        if (responseType.impliesImplicitFlow() || responseType.impliesHybridFlow()) {
            if (responseType.impliesImplicitFlow()) {
                this.userRepository.delete((Object)user);
            }
            Map body = this.authorizationEndpointResponse(user, client, authenticationRequest, scopes, responseType, state);
            LOG.info((Object)String.format("Returning implicit flow %s %s", ResponseMode.FORM_POST, redirectURI));
            if (responseMode.equals((Object)ResponseMode.FORM_POST)) {
                body.put("redirect_uri", redirectURI);
                return new ModelAndView("form_post", body);
            }
            if (responseMode.equals((Object)ResponseMode.QUERY)) {
                UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectURI);
                body.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
                return new ModelAndView((View)new RedirectView(builder.toUriString()));
            }
            if (responseMode.equals((Object)ResponseMode.FRAGMENT)) {
                UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectURI);
                String fragment = body.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
                builder.fragment(fragment);
                return new ModelAndView((View)new RedirectView(builder.toUriString()));
            }
            throw new IllegalArgumentException("Response mode " + responseMode + " not supported");
        }
        throw new IllegalArgumentException("Not yet implemented response_type: " + responseType.toString());
    }

    public static ResponseType validateGrantType(AuthorizationRequest authorizationRequest, OpenIDClient client) {
        ResponseType responseType = authorizationRequest.getResponseType();
        List grants = client.getGrants();
        if ((responseType.impliesImplicitFlow() || responseType.impliesHybridFlow()) && !grants.contains(GrantType.IMPLICIT.getValue())) {
            throw new InvalidGrantException(String.format("Grant types %s does not allow for implicit / hybrid flow", grants));
        }
        if (responseType.impliesCodeFlow() && !grants.contains(GrantType.AUTHORIZATION_CODE.getValue())) {
            throw new InvalidGrantException(String.format("Grant types %s does not allow for authorization code flow", grants));
        }
        return responseType;
    }

    private Map<String, Object> authorizationEndpointResponse(User user, OpenIDClient client, AuthorizationRequest authorizationRequest, List<String> scopes, ResponseType responseType, State state) throws JOSEException, NoSuchProviderException, NoSuchAlgorithmException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String value = this.tokenGenerator.generateAccessTokenWithEmbeddedUserInfo(user, client);
        if (responseType.contains(ResponseType.Value.TOKEN.getValue()) || !this.isOpenIDRequest(authorizationRequest)) {
            this.getAccessTokenRepository().insert((Object)new AccessToken(value, user.getSub(), client.getClientId(), scopes, this.tokenGenerator.getCurrentSigningKeyId(), this.accessTokenValidity(client), false, null));
            result.put("access_token", value);
            result.put("token_type", "Bearer");
        }
        if (responseType.contains(ResponseType.Value.CODE.getValue())) {
            AuthorizationCode authorizationCode = this.createAndSaveAuthorizationCode(authorizationRequest, client, user);
            result.put("code", authorizationCode.getCode());
        }
        if (responseType.contains(OIDCResponseTypeValue.ID_TOKEN.getValue()) && this.isOpenIDRequest(scopes) && this.isOpenIDRequest(authorizationRequest)) {
            AuthenticationRequest authenticationRequest = (AuthenticationRequest)authorizationRequest;
            List claims = this.getClaims(authorizationRequest);
            String idToken = this.getTokenGenerator().generateIDTokenForAuthorizationEndpoint(user, client, authenticationRequest.getNonce(), responseType, value, claims, Optional.ofNullable((String)result.get("code")), state);
            result.put("id_token", idToken);
        }
        result.put("expires_in", client.getAccessTokenValidity());
        if (state != null) {
            result.put("state", state.getValue());
        }
        return result;
    }

    private AuthorizationCode createAndSaveAuthorizationCode(AuthorizationRequest authenticationRequest, OpenIDClient client, User user) {
        AuthorizationCode authorizationCode = this.constructAuthorizationCode(authenticationRequest, client, user);
        this.authorizationCodeRepository.insert((Object)authorizationCode);
        return authorizationCode;
    }

    public static ProvidedRedirectURI validateRedirectionURI(AuthorizationRequest authenticationRequest, OpenIDClient client) throws UnsupportedEncodingException {
        URI redirectionURI = authenticationRequest.getRedirectionURI();
        if (redirectionURI == null) {
            return client.getRedirectUrls().stream().findFirst().map(s -> new ProvidedRedirectURI(s, false)).orElseThrow(() -> new IllegalArgumentException(String.format("Client %s must have at least one redirectURI configured to use the Authorization flow", client.getClientId())));
        }
        String redirectURI = URLDecoder.decode(redirectionURI.toString(), "UTF-8");
        List redirectUrls = client.getRedirectUrls();
        if (CollectionUtils.isEmpty((Collection)redirectUrls) || !redirectUrls.contains(redirectURI)) {
            throw new RedirectMismatchException(String.format("Client %s with registered redirect URI's %s requested authorization with redirectURI %s", client.getClientId(), redirectUrls, redirectURI));
        }
        return new ProvidedRedirectURI(redirectURI, true);
    }

    private String authorizationRedirect(String redirectionURI, State state, String code, boolean isFragment) {
        boolean hasState;
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectionURI);
        boolean bl = hasState = state != null && StringUtils.hasText((String)state.getValue());
        if (isFragment) {
            String fragment = "code=" + code;
            if (hasState) {
                fragment = fragment.concat("&state=" + state.getValue());
            }
            builder.fragment(fragment);
        } else {
            builder.queryParam("code", new Object[]{code});
            if (hasState) {
                builder.queryParam("state", new Object[]{state.getValue()});
            }
        }
        return builder.toUriString();
    }

    public static String validatePrompt(HttpServletRequest request) {
        String prompt = request.getParameter("prompt");
        if (StringUtils.hasText((String)prompt) && !prompt.equals("login")) {
            throw new UnsupportedPromptValueException(AuthorizationEndpoint.unsupportedPromptValue((String)prompt), "Unsupported Prompt value");
        }
        return prompt;
    }

    public static String validatePrompt(Prompt prompt) {
        if (prompt != null && !prompt.toString().contains("login")) {
            throw new UnsupportedPromptValueException(AuthorizationEndpoint.unsupportedPromptValue((String)prompt.toString()), "Unsupported Prompt value");
        }
        return prompt != null ? prompt.toString() : null;
    }

    private static String unsupportedPromptValue(String prompt) {
        switch (prompt) {
            case "none": {
                return "interaction_required";
            }
            case "consent": {
                return "consent_required";
            }
            case "select_account": {
                return "account_selection_required";
            }
        }
        return "invalid_request";
    }

    public static List<String> validateScopes(AuthorizationRequest authorizationRequest, OpenIDClient client) {
        Scope scope = authorizationRequest.getScope();
        List requestedScopes = scope != null ? scope.toStringList() : Collections.emptyList();
        ArrayList scopes = new ArrayList(client.getScopes());
        scopes.addAll(forFreeOpenIDScopes);
        if (!scopes.containsAll(requestedScopes)) {
            List missingScopes = requestedScopes.stream().filter(s -> !scopes.contains(s)).collect(Collectors.toList());
            throw new InvalidScopeException(String.format("Scope(s) %s are not allowed for %s. Allowed scopes: %s", missingScopes, client.getClientId(), client.getScopes()));
        }
        return requestedScopes;
    }

    public TokenGenerator getTokenGenerator() {
        return this.tokenGenerator;
    }

    public AccessTokenRepository getAccessTokenRepository() {
        return this.accessTokenRepository;
    }

    public RefreshTokenRepository getRefreshTokenRepository() {
        return this.refreshTokenRepository;
    }
}

