/*
 * Decompiled with CFR 0.152.
 */
package oidc.secure;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import oidc.model.AccessToken;
import oidc.model.SigningKey;
import oidc.model.SymmetricKey;
import oidc.secure.TokenGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class KeyRollover {
    private static final Log LOG = LogFactory.getLog(KeyRollover.class);
    private TokenGenerator tokenGenerator;
    private MongoTemplate mongoTemplate;
    private boolean cronJobResponsible;

    public KeyRollover(TokenGenerator tokenGenerator, MongoTemplate mongoTemplate, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible) {
        this.tokenGenerator = tokenGenerator;
        this.mongoTemplate = mongoTemplate;
        this.cronJobResponsible = cronJobResponsible;
    }

    @Scheduled(cron="${cron.key-rollover-expression}")
    public void rollover() {
        if (!this.cronJobResponsible) {
            return;
        }
        this.doSigningKeyRollover();
    }

    void doSigningKeyRollover() {
        try {
            SigningKey signingKey = this.tokenGenerator.rolloverSigningKeys();
            LOG.info((Object)("Successful signing key rollover. New signing key: " + signingKey.getKeyId()));
            this.cleanUpSigningKeys();
        }
        catch (Exception e) {
            LOG.error((Object)"Rollover exception", (Throwable)e);
        }
    }

    void doSymmetricKeyRollover() {
        try {
            SymmetricKey symmetricKey = this.tokenGenerator.rolloverSymmetricKeys();
            LOG.info((Object)("Successful symmetric key rollover. New symmetric key: " + symmetricKey.getKeyId()));
            this.cleanUpSymmetricKeys();
        }
        catch (Exception e) {
            LOG.error((Object)"Rollover exception", (Throwable)e);
        }
    }

    private void cleanUpSigningKeys() {
        List signingKeyValues = this.mongoTemplate.findDistinct("signingKeyId", AccessToken.class, String.class);
        signingKeyValues.add(this.tokenGenerator.getCurrentSigningKeyId());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"keyId").not().in((Collection)signingKeyValues));
        List signingKeys = this.mongoTemplate.findAllAndRemove(query, SigningKey.class);
        List deleted = signingKeys.stream().map(SigningKey::getKeyId).collect(Collectors.toList());
        LOG.info((Object)("Deleted signing keys that are no longer referenced by access_tokens: " + String.join((CharSequence)", ", deleted)));
    }

    private void cleanUpSymmetricKeys() {
        List symmetricKeyValues = this.mongoTemplate.findDistinct("symmetricKeyId", SigningKey.class, String.class);
        symmetricKeyValues.add(this.tokenGenerator.getCurrentSymmetricKeyId());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"keyId").not().in((Collection)symmetricKeyValues));
        List symmetricKeys = this.mongoTemplate.findAllAndRemove(query, SymmetricKey.class);
        List deleted = symmetricKeys.stream().map(SymmetricKey::getKeyId).collect(Collectors.toList());
        LOG.info((Object)("Deleted symmetric keys that are no longer referenced by signing keys: " + String.join((CharSequence)", ", deleted)));
    }
}

