/*
 * Decompiled with CFR 0.152.
 */
package oidc.web;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oidc.exceptions.BaseException;
import oidc.web.ConfigurableSamlAuthenticationRequestFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
public class ErrorController
implements org.springframework.boot.web.servlet.error.ErrorController {
    private static final Log LOG = LogFactory.getLog(ErrorController.class);
    private ErrorAttributes errorAttributes;

    public ErrorController(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    public String getErrorPath() {
        return "/error";
    }

    @RequestMapping(value={"/error"})
    public Object error(HttpServletRequest request) throws UnsupportedEncodingException {
        HttpStatus statusCode;
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Map result = this.errorAttributes.getErrorAttributes((WebRequest)webRequest, false);
        LOG.error((Object)("Error has occurred: " + result));
        Throwable error = this.errorAttributes.getError((WebRequest)webRequest);
        boolean status = result.containsKey("status") && !result.get("status").equals(999) && !result.get("status").equals(500);
        HttpStatus httpStatus = statusCode = status ? HttpStatus.resolve((int)((Integer)result.get("status"))) : HttpStatus.BAD_REQUEST;
        if (error != null) {
            LOG.error((Object)"Exception in /error: ", error);
            result.put("details", error.getMessage());
            ResponseStatus annotation = (ResponseStatus)AnnotationUtils.getAnnotation(error.getClass(), ResponseStatus.class);
            HttpStatus httpStatus2 = statusCode = annotation != null ? annotation.value() : statusCode;
            if (error instanceof EmptyResultDataAccessException && result.getOrDefault("path", "/oidc/token").toString().contains("token")) {
                return new ResponseEntity(Collections.singletonMap("error", "invalid_grant"), HttpStatus.BAD_REQUEST);
            }
        }
        result.put("error", this.errorCode(error));
        result.put("status", statusCode.value());
        Object redirectUriValid = request.getAttribute(ConfigurableSamlAuthenticationRequestFilter.REDIRECT_URI_VALID);
        String redirectUri = request.getParameter("redirect_uri");
        if (redirectUriValid != null && ((Boolean)redirectUriValid).booleanValue() && (statusCode.is3xxRedirection() || result.getOrDefault("path", "").contains("authorize")) && StringUtils.hasText((String)redirectUri)) {
            return this.redirectErrorResponse(request, result, error, redirectUri);
        }
        return new ResponseEntity((Object)result, statusCode);
    }

    private String errorCode(Throwable error) {
        return error == null ? "unknown_exception" : (error instanceof BaseException ? ((BaseException)error).getErrorCode() : error.getMessage());
    }

    private String errorMessage(Throwable error) {
        return error == null ? "Unknown exception occurred" : error.getMessage();
    }

    private Object redirectErrorResponse(HttpServletRequest request, Map<String, Object> result, Throwable error, String redirectUri) throws UnsupportedEncodingException {
        String url = URLDecoder.decode(redirectUri, "UTF-8");
        String responseType = this.defaultValue(request, "response_type", "code");
        String responseMode = this.defaultValue(request, "response_mode", "code".equals(responseType) ? "query" : "fragment");
        String errorCode = this.errorCode(error);
        String errorMessage = this.errorMessage(error);
        String state = this.defaultValue(request, "state", null);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)url);
        switch (responseMode) {
            case "query": {
                uriComponentsBuilder.queryParam("error", new Object[]{errorCode}).queryParam("error_description", new Object[]{errorMessage});
                if (!StringUtils.hasText((String)state)) break;
                uriComponentsBuilder.queryParam("state", new Object[]{state});
                break;
            }
            case "fragment": {
                String fragment = String.format("error=%s&error_description=%s", errorCode, errorMessage);
                if (StringUtils.hasText((String)state)) {
                    fragment = fragment.concat(String.format("&state=%s", state));
                }
                uriComponentsBuilder.fragment(fragment);
                break;
            }
            case "form_post": {
                HashMap<String, String> body = new HashMap<String, String>();
                body.put("redirect_uri", url);
                body.put("error", errorCode);
                body.put("error_description", errorMessage);
                if (StringUtils.hasText((String)state)) {
                    body.put("state", state);
                }
                LOG.info((Object)("Post form after error to " + url));
                return new ModelAndView("form_post", body);
            }
        }
        URI uri = uriComponentsBuilder.build().toUri();
        LOG.info((Object)("Redirection after error to " + uri));
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uri);
        HttpStatus statusCode = HttpStatus.FOUND;
        return new ResponseEntity(result, (MultiValueMap)headers, statusCode);
    }

    private String defaultValue(HttpServletRequest request, String key, String defaultValue) {
        String value = request.getParameter(key);
        return StringUtils.hasText((String)value) ? value : defaultValue;
    }
}

