/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import java.io.IOException;
import java.time.Clock;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oidc.endpoints.OrderedMap;
import oidc.exceptions.InvalidGrantException;
import oidc.exceptions.UnauthorizedException;
import oidc.model.AccessToken;
import oidc.model.User;
import oidc.repository.AccessTokenRepository;
import oidc.secure.TokenGenerator;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserInfoEndpoint
implements OrderedMap {
    private AccessTokenRepository accessTokenRepository;
    private TokenGenerator tokenGenerator;

    public UserInfoEndpoint(AccessTokenRepository accessTokenRepository, TokenGenerator tokenGenerator) {
        this.accessTokenRepository = accessTokenRepository;
        this.tokenGenerator = tokenGenerator;
    }

    @GetMapping(value={"oidc/userinfo"})
    public Map<String, Object> getUserInfo(HttpServletRequest request) throws IOException, ParseException {
        return this.userInfo(request);
    }

    @PostMapping(value={"oidc/userinfo"}, consumes={"application/x-www-form-urlencoded"})
    public Map<String, Object> postUserInfo(HttpServletRequest request) throws ParseException, IOException {
        return this.userInfo(request);
    }

    private Map<String, Object> userInfo(HttpServletRequest request) throws ParseException, IOException {
        HTTPRequest httpRequest = ServletUtils.createHTTPRequest((HttpServletRequest)request);
        UserInfoRequest userInfoRequest = UserInfoRequest.parse((HTTPRequest)httpRequest);
        String accessTokenValue = userInfoRequest.getAccessToken().getValue();
        AccessToken accessToken = this.accessTokenRepository.findByValue(accessTokenValue);
        if (accessToken.isExpired(Clock.systemDefaultZone())) {
            throw new UnauthorizedException("Access token expired");
        }
        if (accessToken.isClientCredentials()) {
            throw new InvalidGrantException("UserEndpoint not allowed for Client Credentials");
        }
        User user = this.tokenGenerator.decryptAccessTokenWithEmbeddedUserInfo(accessTokenValue);
        Map attributes = user.getAttributes();
        attributes.put("updated_at", user.getUpdatedAt());
        attributes.put("sub", user.getSub());
        return this.sortMap(attributes);
    }
}

