/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenIntrospectionRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.PlainClientSecret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import java.io.IOException;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oidc.endpoints.OrderedMap;
import oidc.endpoints.SecureEndpoint;
import oidc.exceptions.UnauthorizedException;
import oidc.model.AccessToken;
import oidc.model.OpenIDClient;
import oidc.model.User;
import oidc.repository.AccessTokenRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.secure.TokenGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IntrospectEndpoint
extends SecureEndpoint
implements OrderedMap {
    private AccessTokenRepository accessTokenRepository;
    private OpenIDClientRepository openIDClientRepository;
    private String issuer;
    private TokenGenerator tokenGenerator;

    public IntrospectEndpoint(AccessTokenRepository accessTokenRepository, OpenIDClientRepository openIDClientRepository, TokenGenerator tokenGenerator, @Value(value="${spring.security.saml2.service-provider.entity-id}") String issuer) {
        this.accessTokenRepository = accessTokenRepository;
        this.openIDClientRepository = openIDClientRepository;
        this.tokenGenerator = tokenGenerator;
        this.issuer = issuer;
    }

    @PostMapping(value={"oidc/introspect"}, consumes={"application/x-www-form-urlencoded"})
    public Map<String, Object> introspect(HttpServletRequest request) throws ParseException, IOException {
        HTTPRequest httpRequest = ServletUtils.createHTTPRequest((HttpServletRequest)request);
        TokenIntrospectionRequest tokenIntrospectionRequest = TokenIntrospectionRequest.parse((HTTPRequest)httpRequest);
        ClientAuthentication clientAuthentication = tokenIntrospectionRequest.getClientAuthentication();
        String accessTokenValue = tokenIntrospectionRequest.getToken().getValue();
        if (!(clientAuthentication instanceof PlainClientSecret)) {
            throw new BadCredentialsException("Invalid user / secret");
        }
        OpenIDClient resourceServer = this.openIDClientRepository.findByClientId(clientAuthentication.getClientID().getValue());
        if (!this.secretsMatch((PlainClientSecret)clientAuthentication, resourceServer)) {
            throw new BadCredentialsException("Invalid user / secret");
        }
        if (!resourceServer.isResourceServer()) {
            throw new BadCredentialsException("Requires ResourceServer");
        }
        AccessToken accessToken = this.accessTokenRepository.findByValue(accessTokenValue);
        if (accessToken.isExpired(Clock.systemDefaultZone())) {
            return Collections.singletonMap("active", false);
        }
        OpenIDClient openIDClient = this.openIDClientRepository.findByClientId(accessToken.getClientId());
        if (!openIDClient.getAllowedResourceServers().contains(resourceServer.getClientId())) {
            throw new UnauthorizedException(String.format("RP %s is not allowed to use the API of resource server %s. Allowed resource servers are %s", accessToken.getClientId(), resourceServer.getClientId(), openIDClient.getAllowedResourceServers()));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!accessToken.isClientCredentials()) {
            User user = this.tokenGenerator.decryptAccessTokenWithEmbeddedUserInfo(accessTokenValue);
            result.put("updated_at", user.getUpdatedAt());
            if (resourceServer.isIncludeUnspecifiedNameID()) {
                result.put("unspecified_id", user.getUnspecifiedNameId());
            }
            result.put("authenticating_authority", user.getAuthenticatingAuthority());
            result.put("sub", user.getSub());
            result.putAll(user.getAttributes());
        }
        result.put("active", true);
        result.put("scope", String.join((CharSequence)",", accessToken.getScopes()));
        result.put("client_id", accessToken.getClientId());
        result.put("exp", accessToken.getExpiresIn().getTime() / 1000L);
        result.put("sub", accessToken.getSub());
        result.put("iss", this.issuer);
        result.put("token_type", "Bearer");
        return this.sortMap(result);
    }
}

