/*
 * Decompiled with CFR 0.152.
 */
package oidc.web;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.Prompt;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oidc.endpoints.AuthorizationEndpoint;
import oidc.manage.ServiceProviderTranslation;
import oidc.model.AuthenticationRequest;
import oidc.model.OpenIDClient;
import oidc.repository.AuthenticationRequestRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.secure.JWTRequest;
import oidc.web.URLCoding;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.SamlRequestMatcher;
import org.springframework.security.saml.provider.provisioning.SamlProviderProvisioning;
import org.springframework.security.saml.provider.service.SamlAuthenticationRequestFilter;
import org.springframework.security.saml.provider.service.ServiceProviderService;
import org.springframework.security.saml.saml2.authentication.AuthenticationContextClassReference;
import org.springframework.security.saml.saml2.authentication.RequestedAuthenticationContext;
import org.springframework.security.saml.saml2.authentication.Scoping;
import org.springframework.security.saml.saml2.metadata.IdentityProviderMetadata;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ConfigurableSamlAuthenticationRequestFilter
extends SamlAuthenticationRequestFilter
implements URLCoding {
    private PortResolverImpl portResolver;
    private AuthenticationRequestRepository authenticationRequestRepository;
    private OpenIDClientRepository openIDClientRepository;
    static String REDIRECT_URI_VALID = "REDIRECT_URI_VALID";

    public ConfigurableSamlAuthenticationRequestFilter(SamlProviderProvisioning<ServiceProviderService> provisioning, SamlRequestMatcher samlRequestMatcher, AuthenticationRequestRepository authenticationRequestRepository, OpenIDClientRepository openIDClientRepository) {
        super(provisioning, (RequestMatcher)samlRequestMatcher);
        this.openIDClientRepository = openIDClientRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.portResolver = new PortResolverImpl();
    }

    protected String getRelayState(ServiceProviderService provider, HttpServletRequest request) {
        return request.getParameter("client_id");
    }

    private org.springframework.security.saml.saml2.authentication.AuthenticationRequest enhanceAuthenticationRequest(ServiceProviderService provider, HttpServletRequest request, org.springframework.security.saml.saml2.authentication.AuthenticationRequest authenticationRequest) {
        String loginHint;
        String acrValues;
        String clientId = this.getRelayState(provider, request);
        if (StringUtils.hasText((String)clientId)) {
            String entityId = ServiceProviderTranslation.translateClientId((String)clientId);
            authenticationRequest.setScoping(new Scoping(new ArrayList(), Collections.singletonList(entityId), Integer.valueOf(1)));
        }
        String prompt = AuthorizationEndpoint.validatePrompt((HttpServletRequest)request);
        authenticationRequest.setForceAuth(Boolean.valueOf("login".equals(prompt)));
        if (!authenticationRequest.isForceAuth().booleanValue() && StringUtils.hasText((String)request.getParameter("max_age"))) {
            authenticationRequest.setForceAuth(Boolean.valueOf(true));
        }
        if (StringUtils.hasText((String)(acrValues = request.getParameter("acr_values")))) {
            List acrList = Arrays.stream(acrValues.split(" ")).map(ACR::new).collect(Collectors.toList());
            this.parseAcrValues(authenticationRequest, acrList);
        }
        String requestP = request.getParameter("request");
        String requestUrlP = request.getParameter("request_uri");
        if (StringUtils.hasText((String)requestP) || StringUtils.hasText((String)requestUrlP)) {
            OpenIDClient openIDClient = this.openIDClientRepository.findByClientId(clientId);
            try {
                com.nimbusds.openid.connect.sdk.AuthenticationRequest authRequest = com.nimbusds.openid.connect.sdk.AuthenticationRequest.parse((HTTPRequest)ServletUtils.createHTTPRequest((HttpServletRequest)request));
                authRequest = JWTRequest.parse((com.nimbusds.openid.connect.sdk.AuthenticationRequest)authRequest, (OpenIDClient)openIDClient);
                List acrValuesObjects = authRequest.getACRValues();
                this.parseAcrValues(authenticationRequest, acrValuesObjects);
                Prompt authRequestPrompt = authRequest.getPrompt();
                prompt = AuthorizationEndpoint.validatePrompt((Prompt)authRequestPrompt);
                if (!authenticationRequest.isForceAuth().booleanValue() && authRequest.getMaxAge() > -1) {
                    authenticationRequest.setForceAuth(Boolean.valueOf(true));
                }
                if (!authenticationRequest.isForceAuth().booleanValue() && prompt != null) {
                    authenticationRequest.setForceAuth(Boolean.valueOf(prompt.contains("login")));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (StringUtils.hasText((String)(loginHint = request.getParameter("login_hint")))) {
            Scoping scoping = authenticationRequest.getScoping();
            if (scoping == null) {
                authenticationRequest.setScoping(new Scoping(new ArrayList(), Collections.emptyList(), Integer.valueOf(0)));
            }
            List idpList = authenticationRequest.getScoping().getIdpList();
            loginHint = this.decode(loginHint);
            Stream.of(loginHint.split(",")).map(String::trim).filter(arg_0 -> this.isValidURI(arg_0)).forEach(idpEntityId -> idpList.add(idpEntityId.trim()));
        }
        return authenticationRequest;
    }

    private boolean isValidURI(String uri) {
        try {
            new URI(uri);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (this.getRequestMatcher().matches(request) && (authentication == null || !authentication.isAuthenticated())) {
            this.validateAuthorizationRequest(request);
            ServiceProviderService provider = (ServiceProviderService)this.getProvisioning().getHostedProvider();
            IdentityProviderMetadata idp = (IdentityProviderMetadata)provider.getRemoteProviders().get(0);
            org.springframework.security.saml.saml2.authentication.AuthenticationRequest authenticationRequest = provider.authenticationRequest(idp);
            authenticationRequest = this.enhanceAuthenticationRequest(provider, request, authenticationRequest);
            this.saveAuthenticationRequestUrl(request, authenticationRequest);
            this.sendAuthenticationRequest(provider, request, response, authenticationRequest, authenticationRequest.getDestination());
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void saveAuthenticationRequestUrl(HttpServletRequest request, org.springframework.security.saml.saml2.authentication.AuthenticationRequest authenticationRequest) {
        String id = authenticationRequest.getId();
        LocalDateTime ldt = LocalDateTime.now().plusSeconds(900L);
        Date expiresIn = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        DefaultSavedRequest savedRequest = new DefaultSavedRequest(request, (PortResolver)this.portResolver);
        this.authenticationRequestRepository.insert((Object)new AuthenticationRequest(id, expiresIn, savedRequest.getRedirectUrl()));
    }

    private void validateAuthorizationRequest(HttpServletRequest request) throws IOException {
        try {
            AuthorizationRequest authorizationRequest = AuthorizationRequest.parse((HTTPRequest)ServletUtils.createHTTPRequest((HttpServletRequest)request));
            ClientID clientID = authorizationRequest.getClientID();
            if (clientID != null) {
                OpenIDClient openIDClient = this.openIDClientRepository.findByClientId(clientID.getValue());
                AuthorizationEndpoint.validateRedirectionURI((AuthorizationRequest)authorizationRequest, (OpenIDClient)openIDClient);
                request.setAttribute(REDIRECT_URI_VALID, (Object)true);
                AuthorizationEndpoint.validateScopes((AuthorizationRequest)authorizationRequest, (OpenIDClient)openIDClient);
                AuthorizationEndpoint.validateGrantType((AuthorizationRequest)authorizationRequest, (OpenIDClient)openIDClient);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private void parseAcrValues(org.springframework.security.saml.saml2.authentication.AuthenticationRequest authenticationRequest, List<ACR> acrValuesObjects) {
        if (!CollectionUtils.isEmpty(acrValuesObjects)) {
            authenticationRequest.setAuthenticationContextClassReferences(acrValuesObjects.stream().map(acrValue -> AuthenticationContextClassReference.fromUrn((String)acrValue.getValue())).collect(Collectors.toList()));
            authenticationRequest.setRequestedAuthenticationContext(RequestedAuthenticationContext.exact);
        }
    }
}

