/*
 * Decompiled with CFR 0.152.
 */
package oidc.eduid;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oidc.eduid.FaultTolerantResponseErrorHandler;
import oidc.model.OpenIDClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class AttributePseudonymisation {
    private static final Log LOG = LogFactory.getLog(AttributePseudonymisation.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final HttpHeaders headers;
    private final URI eduIdUri;
    private final boolean enabled;

    public AttributePseudonymisation(@Value(value="${eduid.uri}") URI eduIdUri, @Value(value="${eduid.user}") String user, @Value(value="${eduid.password}") String password, @Value(value="${eduid.enabled}") boolean enabled) {
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new FaultTolerantResponseErrorHandler());
        this.eduIdUri = eduIdUri;
        this.enabled = enabled;
        this.headers = new HttpHeaders();
        this.headers.setContentType(MediaType.APPLICATION_JSON);
        this.headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        this.headers.setBasicAuth(user, password);
    }

    public Map<String, Object> pseudonymise(OpenIDClient resourceServer, OpenIDClient openIDClient, Map<String, Object> attributes) {
        boolean eduidPresent = attributes.containsKey("eduid");
        boolean resourceServerIsDifferent = !resourceServer.getClientId().equals(openIDClient.getClientId());
        LOG.info((Object)String.format("Starting to pseudonymise for RS %s and openIDclient %s. Enabled is %s, eduidPresent is %s, resourceServerIsDifferent is %s", resourceServer.getClientId(), openIDClient.getClientId(), this.enabled, eduidPresent, resourceServerIsDifferent));
        if (this.enabled && eduidPresent && resourceServerIsDifferent) {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.headers);
            List uids = (List)attributes.get("uids");
            if (CollectionUtils.isEmpty((Collection)uids)) {
                throw new IllegalArgumentException("Required user attribute 'uids' not present in " + attributes);
            }
            String uriString = UriComponentsBuilder.fromUri((URI)this.eduIdUri).queryParam("uid", new Object[]{uids.get(0)}).queryParam("sp_entity_id", new Object[]{resourceServer.getClientId()}).queryParam("sp_institution_guid", new Object[]{resourceServer.getInstitutionGuid()}).toUriString();
            ResponseEntity responseEntity = this.restTemplate.exchange(uriString, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                Map body = (Map)responseEntity.getBody();
                LOG.info((Object)String.format("Pseudonymise result %s for RS %s, RP %s", body, resourceServer.getClientId(), openIDClient.getClientId()));
                attributes.putAll(body);
            } else {
                attributes.remove("eduid");
                LOG.error((Object)String.format("Error %s occurred in pseudonymise for RS %s, RP %s, attributes %s", requestEntity.getBody(), resourceServer.getClientId(), openIDClient.getClientId(), attributes));
            }
        }
        return attributes;
    }
}

