/*
 * Decompiled with CFR 0.152.
 */
package oidc.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.List;
import oidc.model.OpenIDClient;
import oidc.model.User;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="user_consents")
public class UserConsent {
    @Id
    private String id;
    private String sub;
    private String clientName;
    private List<String> scopes;
    private int hash;
    private Date lastAccessed;

    public UserConsent(User user, List<String> scopes, OpenIDClient openIDClient) {
        this.sub = user.getSub();
        this.scopes = scopes;
        this.clientName = openIDClient.getName();
        this.hash = this.hashAttributes(user);
        this.lastAccessed = new Date();
    }

    @Transient
    @JsonIgnore
    private int hashAttributes(User user) {
        return user.getAttributes().toString().hashCode();
    }

    public int getHash() {
        return this.hash;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public UserConsent updateHash(User user, List<String> scopes) {
        this.hash = this.hashAttributes(user);
        this.scopes = scopes;
        this.lastAccessed = new Date();
        return this;
    }

    public boolean renewConsentRequired(User user, List<String> newScopes) {
        return this.hash != this.hashAttributes(user) || !this.scopes.containsAll(newScopes);
    }

    public UserConsent() {
    }
}

