/*
 * Decompiled with CFR 0.152.
 */
package oidc.model;

import java.util.Map;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="identity_providers")
public class IdentityProvider {
    @Id
    private String id;
    private String entityId;
    private String name;
    private String nameNl;

    public IdentityProvider(String entityId) {
        this.entityId = entityId;
        this.name = entityId;
        this.nameNl = entityId;
    }

    public IdentityProvider(Map<String, Object> root) {
        Map data = (Map)root.get("data");
        this.entityId = (String)data.get("entityid");
        Map metaDataFields = (Map)data.get("metaDataFields");
        this.name = (String)metaDataFields.get("name:en");
        this.nameNl = (String)metaDataFields.get("name:nl");
    }

    public String getId() {
        return this.id;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getName() {
        return this.name;
    }

    public String getNameNl() {
        return this.nameNl;
    }

    public IdentityProvider() {
    }
}

