/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import oidc.model.OpenIDClient;
import oidc.repository.AccessTokenRepository;
import oidc.repository.RefreshTokenRepository;
import oidc.secure.TokenGenerator;

public interface OidcEndpoint {
    default public boolean isOpenIDRequest(AuthorizationRequest authorizationRequest) {
        return authorizationRequest instanceof AuthenticationRequest;
    }

    default public boolean isOpenIDRequest(List<String> scopes) {
        return scopes.contains("openid");
    }

    default public List<String> getClaims(AuthorizationRequest authorizationRequest) {
        AuthenticationRequest authenticationRequest;
        ClaimsRequest claimsRequest;
        ArrayList<String> idTokenClaims = new ArrayList<String>();
        if (this.isOpenIDRequest(authorizationRequest) && (claimsRequest = (authenticationRequest = (AuthenticationRequest)authorizationRequest).getClaims()) != null) {
            idTokenClaims.addAll(claimsRequest.getIDTokenClaims().stream().map(entry -> entry.getClaimName()).collect(Collectors.toList()));
        }
        return idTokenClaims;
    }

    default public Date accessTokenValidity(OpenIDClient client) {
        return this.tokenValidity(client.getAccessTokenValidity());
    }

    default public Date refreshTokenValidity(OpenIDClient client) {
        return this.tokenValidity(client.getRefreshTokenValidity());
    }

    default public Date tokenValidity(int validity) {
        LocalDateTime ldt = LocalDateTime.now().plusSeconds(validity);
        return Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
    }

    public TokenGenerator getTokenGenerator();

    public AccessTokenRepository getAccessTokenRepository();

    public RefreshTokenRepository getRefreshTokenRepository();
}

