/*
 * Decompiled with CFR 0.152.
 */
package oidc.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oidc.manage.ServiceProviderTranslation;
import oidc.model.Scope;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.security.saml.saml2.metadata.NameIdFormat;
import org.springframework.util.StringUtils;

@Document(collection="clients")
public class OpenIDClient {
    @Transient
    private static final List<String> nameIdFormats = Arrays.asList("NameIDFormat", "NameIDFormats:0", "NameIDFormats:1", "NameIDFormats:2");
    @Id
    private String id;
    private String clientId;
    private String institutionGuid;
    private String name;
    private String nameNl;
    private String secret;
    private String clientSecretJWT;
    private List<String> redirectUrls;
    private List<Scope> scopes;
    private List<String> grants;
    private List<String> allowedResourceServers;
    private boolean resourceServer;
    private boolean publicClient;
    private int accessTokenValidity;
    private int refreshTokenValidity;
    private String discoveryUrl;
    private String signingCertificate;
    private String signingCertificateUrl;
    private boolean includeUnspecifiedNameID;
    private boolean consentRequired;

    public OpenIDClient(String clientId, List<String> redirectUrls, List<Scope> scopes, List<String> grants) {
        this.clientId = clientId;
        this.redirectUrls = redirectUrls;
        this.scopes = scopes;
        this.grants = grants;
    }

    public OpenIDClient(Map<String, Object> root) {
        Map data = (Map)root.get("data");
        this.clientId = ServiceProviderTranslation.translateServiceProviderEntityId((String)((String)String.class.cast(data.get("entityid"))));
        Map metaDataFields = (Map)data.get("metaDataFields");
        this.institutionGuid = (String)metaDataFields.get("coin:institution_guid");
        this.name = (String)metaDataFields.get("name:en");
        this.nameNl = (String)metaDataFields.get("name:nl");
        this.secret = (String)metaDataFields.get("secret");
        this.clientSecretJWT = (String)metaDataFields.get("clientSecretJWT");
        this.redirectUrls = (List)metaDataFields.get("redirectUrls");
        this.scopes = metaDataFields.getOrDefault("scopes", Collections.singletonList("oidc")).stream().map(val -> val instanceof String ? new Scope((String)val) : new Scope((Map)val)).collect(Collectors.toList());
        this.grants = metaDataFields.getOrDefault("grants", Collections.singletonList("authorization_code"));
        this.allowedResourceServers = ((List)data.getOrDefault("allowedResourceServers", new ArrayList())).stream().map(e -> (String)e.get("name")).collect(Collectors.toList());
        this.resourceServer = this.parseBoolean(metaDataFields.get("isResourceServer"));
        this.publicClient = this.parseBoolean(metaDataFields.get("isPublicClient"));
        this.accessTokenValidity = metaDataFields.getOrDefault("accessTokenValidity", 3600);
        this.refreshTokenValidity = metaDataFields.getOrDefault("refreshTokenValidity", 3600);
        this.discoveryUrl = (String)metaDataFields.get("discoveryurl");
        this.signingCertificate = (String)metaDataFields.get("oidc:signingCertificate");
        this.signingCertificateUrl = (String)metaDataFields.get("oidc:signingCertificateUrl");
        this.consentRequired = this.parseBoolean(metaDataFields.get("oidc:consentRequired"));
        this.includeUnspecifiedNameID = nameIdFormats.stream().filter(id -> metaDataFields.containsKey(id)).map(id -> metaDataFields.get(id).equals(NameIdFormat.UNSPECIFIED)).findAny().isPresent();
    }

    @Transient
    public boolean certificateSpecified() {
        return StringUtils.hasText((String)this.signingCertificate) || StringUtils.hasText((String)this.signingCertificateUrl) || StringUtils.hasText((String)this.discoveryUrl);
    }

    @Transient
    private boolean parseBoolean(Object val) {
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return "1".equals(val);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getInstitutionGuid() {
        return this.institutionGuid;
    }

    public String getName() {
        return this.name;
    }

    public String getNameNl() {
        return this.nameNl;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getClientSecretJWT() {
        return this.clientSecretJWT;
    }

    public List<String> getRedirectUrls() {
        return this.redirectUrls;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public List<String> getGrants() {
        return this.grants;
    }

    public List<String> getAllowedResourceServers() {
        return this.allowedResourceServers;
    }

    public boolean isResourceServer() {
        return this.resourceServer;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public int getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    public int getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public String getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    public String getSigningCertificate() {
        return this.signingCertificate;
    }

    public String getSigningCertificateUrl() {
        return this.signingCertificateUrl;
    }

    public boolean isIncludeUnspecifiedNameID() {
        return this.includeUnspecifiedNameID;
    }

    public boolean isConsentRequired() {
        return this.consentRequired;
    }

    public OpenIDClient() {
    }
}

