/*
 * Decompiled with CFR 0.152.
 */
package oidc.web;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oidc.model.AuthenticationRequest;
import oidc.repository.AuthenticationRequestRepository;
import oidc.user.OidcSamlAuthentication;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;

public class ConcurrentSavedRequestAwareAuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private AuthenticationRequestRepository authenticationRequestRepository;

    public ConcurrentSavedRequestAwareAuthenticationSuccessHandler(AuthenticationRequestRepository authenticationRequestRepository) {
        this.authenticationRequestRepository = authenticationRequestRepository;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        OidcSamlAuthentication samlAuthentication = (OidcSamlAuthentication)authentication;
        AuthenticationRequest authenticationRequest = (AuthenticationRequest)this.authenticationRequestRepository.findById((Object)samlAuthentication.getAuthenticationRequestID()).orElseThrow(() -> new IllegalArgumentException("No Authentication Request found for ID: " + samlAuthentication.getAuthenticationRequestID()));
        this.getRedirectStrategy().sendRedirect(request, response, authenticationRequest.getOriginalRequestUrl());
    }
}

