/*
 * Decompiled with CFR 0.152.
 */
package oidc.crypto;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.encoders.Hex;

/*
 * Exception performing whole class analysis ignored.
 */
public class KeyGenerator {
    private static final BouncyCastleProvider bcProvider = new BouncyCastleProvider();

    private KeyGenerator() {
    }

    public static String[] generateKeys() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
        pemWriter.writeObject((Object)kp.getPrivate());
        pemWriter.close();
        String pemString = ((Object)writer).toString();
        String certificate = KeyGenerator.certificate((KeyPair)kp);
        return new String[]{pemString, certificate};
    }

    public static String certificate(KeyPair keyPair) throws OperatorCreationException, CertificateException, CertIOException {
        X500Name dnName = new X500Name("CN=test,O=Test Certificate");
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSA").build(keyPair.getPrivate());
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(dnName, new BigInteger(Long.toString(System.currentTimeMillis())), new Date(), Date.from(LocalDateTime.now().plusYears(1L).toInstant(ZoneOffset.UTC)), dnName, keyPair.getPublic());
        X509Certificate certificate = new JcaX509CertificateConverter().setProvider((Provider)bcProvider).getCertificate(certBuilder.build(contentSigner));
        String result = "-----BEGIN CERTIFICATE-----\n";
        result = result + Base64.getEncoder().encodeToString(certificate.getEncoded());
        result = result + "\n-----END CERTIFICATE-----\n";
        return result;
    }

    public static String oneWayHash(String original, String secret) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
        messageDigest.update(secret.getBytes());
        return new String(Hex.encode((byte[])messageDigest.digest(original.getBytes())));
    }

    static {
        Security.addProvider((Provider)bcProvider);
    }
}

