/*
 * Decompiled with CFR 0.152.
 */
package oidc.eduid;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import oidc.eduid.FaultTolerantResponseErrorHandler;
import oidc.model.OpenIDClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class AttributePseudonymisation {
    private static final Log LOG = LogFactory.getLog(AttributePseudonymisation.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final HttpHeaders headers;
    private final URI eduIdUri;
    private final boolean enabled;

    public AttributePseudonymisation(@Value(value="${eduid.uri}") URI eduIdUri, @Value(value="${eduid.user}") String user, @Value(value="${eduid.password}") String password, @Value(value="${eduid.enabled}") boolean enabled) {
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new FaultTolerantResponseErrorHandler());
        this.eduIdUri = eduIdUri;
        this.enabled = enabled;
        this.headers = new HttpHeaders();
        this.headers.setContentType(MediaType.APPLICATION_JSON);
        this.headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        this.headers.setBasicAuth(user, password);
    }

    public Optional<Map<String, String>> pseudonymise(OpenIDClient resourceServer, OpenIDClient openIDClient, String eduId, List<String> uids) {
        boolean eduIdMissing = StringUtils.isEmpty((Object)eduId);
        boolean resourceServerEquals = resourceServer.getClientId().equals(openIDClient.getClientId());
        LOG.debug((Object)String.format("Starting to pseudonymise for RS %s and openIDclient %s. Enabled is %s, eduIdMissing is %s, resourceServerEquals is %s", resourceServer.getClientId(), openIDClient.getClientId(), this.enabled, eduIdMissing, resourceServerEquals));
        if (!this.enabled || eduIdMissing || resourceServerEquals) {
            return Optional.empty();
        }
        HashMap result = new HashMap();
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.headers);
        if (CollectionUtils.isEmpty(uids)) {
            throw new IllegalArgumentException("Required user attribute 'uids' not presen");
        }
        String uriString = UriComponentsBuilder.fromUri((URI)this.eduIdUri).queryParam("uid", new Object[]{uids.get(0)}).queryParam("sp_entity_id", new Object[]{resourceServer.getClientId()}).queryParam("sp_institution_guid", new Object[]{resourceServer.getInstitutionGuid()}).toUriString();
        ResponseEntity responseEntity = this.restTemplate.exchange(uriString, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            LOG.error((Object)String.format("Error %s occurred in pseudonymise for RS %s, RP %s, response %s", requestEntity.getBody(), resourceServer.getClientId(), openIDClient.getClientId(), responseEntity));
            return Optional.empty();
        }
        Map body = (Map)responseEntity.getBody();
        result.putAll(body);
        LOG.debug((Object)String.format("Pseudonymise result %s for RS %s, RP %s", body, resourceServer.getClientId(), openIDClient.getClientId()));
        return Optional.of(result);
    }
}

