/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretJWT;
import com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import com.nimbusds.oauth2.sdk.auth.PlainClientSecret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.time.Clock;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import oidc.crypto.KeyGenerator;
import oidc.endpoints.ConcurrentAuthorizationCodeRepository;
import oidc.endpoints.OidcEndpoint;
import oidc.endpoints.SecureEndpoint;
import oidc.exceptions.CodeVerifierMissingException;
import oidc.exceptions.InvalidGrantException;
import oidc.exceptions.JWTAuthorizationGrantsException;
import oidc.exceptions.RedirectMismatchException;
import oidc.exceptions.UnauthorizedException;
import oidc.log.MDCContext;
import oidc.model.AccessToken;
import oidc.model.AuthorizationCode;
import oidc.model.EncryptedTokenValue;
import oidc.model.OpenIDClient;
import oidc.model.RefreshToken;
import oidc.model.Scope;
import oidc.model.TokenValue;
import oidc.model.User;
import oidc.repository.AccessTokenRepository;
import oidc.repository.AuthorizationCodeRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.repository.RefreshTokenRepository;
import oidc.repository.UserRepository;
import oidc.secure.JWTRequest;
import oidc.secure.TokenGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.ContentType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TokenEndpoint
extends SecureEndpoint
implements OidcEndpoint {
    private static final Log LOG = LogFactory.getLog(TokenEndpoint.class);
    private final ConcurrentAuthorizationCodeRepository concurrentAuthorizationCodeRepository;
    private final AuthorizationCodeRepository authorizationCodeRepository;
    private final AccessTokenRepository accessTokenRepository;
    private final RefreshTokenRepository refreshTokenRepository;
    private final UserRepository userRepository;
    private final OpenIDClientRepository openIDClientRepository;
    private final TokenGenerator tokenGenerator;
    private final String tokenEndpoint;
    private final String salt;
    private final HttpHeaders responseHttpHeaders;

    public TokenEndpoint(OpenIDClientRepository openIDClientRepository, AuthorizationCodeRepository authorizationCodeRepository, ConcurrentAuthorizationCodeRepository concurrentAuthorizationCodeRepository, AccessTokenRepository accessTokenRepository, RefreshTokenRepository refreshTokenRepository, UserRepository userRepository, TokenGenerator tokenGenerator, @Value(value="${oidc_token_endpoint}") String tokenEndpoint, @Value(value="${access_token_one_way_hash_salt}") String salt) {
        this.openIDClientRepository = openIDClientRepository;
        this.authorizationCodeRepository = authorizationCodeRepository;
        this.concurrentAuthorizationCodeRepository = concurrentAuthorizationCodeRepository;
        this.accessTokenRepository = accessTokenRepository;
        this.refreshTokenRepository = refreshTokenRepository;
        this.userRepository = userRepository;
        this.tokenGenerator = tokenGenerator;
        this.tokenEndpoint = tokenEndpoint;
        this.salt = salt;
        this.responseHttpHeaders = this.getResponseHeaders();
    }

    @PostMapping(value={"oidc/token"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity token(HttpServletRequest request) throws IOException, com.nimbusds.oauth2.sdk.ParseException, JOSEException, ParseException, CertificateException, BadJOSEException {
        HTTPRequest httpRequest = ServletUtils.createHTTPRequest((HttpServletRequest)request);
        TokenRequest tokenRequest = TokenRequest.parse((HTTPRequest)httpRequest);
        ClientAuthentication clientAuthentication = tokenRequest.getClientAuthentication();
        if (clientAuthentication != null && !(clientAuthentication instanceof PlainClientSecret) && !(clientAuthentication instanceof JWTAuthentication)) {
            throw new IllegalArgumentException(String.format("Unsupported '%s' findByClientId authentication in token endpoint", clientAuthentication.getClass()));
        }
        AuthorizationGrant authorizationGrant = tokenRequest.getAuthorizationGrant();
        if (clientAuthentication == null && authorizationGrant instanceof AuthorizationCodeGrant && ((AuthorizationCodeGrant)authorizationGrant).getCodeVerifier() == null) {
            throw new CodeVerifierMissingException("code_verifier required without client authentication");
        }
        String clientId = clientAuthentication != null ? clientAuthentication.getClientID().getValue() : tokenRequest.getClientID().getValue();
        OpenIDClient client = this.openIDClientRepository.findByClientId(clientId);
        if (clientAuthentication == null && !client.isPublicClient()) {
            throw new UnauthorizedException("Non-public client requires authentication");
        }
        if (clientAuthentication != null) {
            if (clientAuthentication instanceof PlainClientSecret && !this.secretsMatch((PlainClientSecret)clientAuthentication, client)) {
                throw new UnauthorizedException("Invalid user / secret");
            }
            if (clientAuthentication instanceof JWTAuthentication && !this.verifySignature((JWTAuthentication)clientAuthentication, client, this.tokenEndpoint)) {
                throw new UnauthorizedException("Invalid user / signature");
            }
        }
        MDCContext.mdcContext((String[])new String[]{"action", "Token", "rp", clientId, "grant", authorizationGrant.getType().getValue()});
        if (!client.getGrants().contains(authorizationGrant.getType().getValue())) {
            throw new InvalidGrantException("Invalid grant: " + authorizationGrant.getType().getValue());
        }
        if (authorizationGrant instanceof AuthorizationCodeGrant) {
            return this.handleAuthorizationCodeGrant((AuthorizationCodeGrant)authorizationGrant, client);
        }
        if (authorizationGrant instanceof ClientCredentialsGrant) {
            return this.handleClientCredentialsGrant(client);
        }
        if (authorizationGrant instanceof RefreshTokenGrant) {
            return this.handleRefreshCodeGrant((RefreshTokenGrant)authorizationGrant, client);
        }
        throw new IllegalArgumentException("Not supported - yet - authorizationGrant " + authorizationGrant.getType().getValue());
    }

    boolean verifySignature(JWTAuthentication jwtAuthentication, OpenIDClient openIDClient, String tokenEndpoint) throws JOSEException, ParseException, CertificateException, IOException, BadJOSEException {
        Optional jwtClaimsSetOptional = this.jwtClaimsSet(openIDClient, jwtAuthentication);
        if (!jwtClaimsSetOptional.isPresent()) {
            return false;
        }
        JWTClaimsSet claimsSet = (JWTClaimsSet)jwtClaimsSetOptional.get();
        if (!openIDClient.getClientId().equals(claimsSet.getIssuer())) {
            throw new JWTAuthorizationGrantsException("Invalid issuer");
        }
        if (!openIDClient.getClientId().equals(claimsSet.getSubject())) {
            throw new JWTAuthorizationGrantsException("Invalid subject");
        }
        if (!claimsSet.getAudience().contains(tokenEndpoint)) {
            throw new JWTAuthorizationGrantsException("Invalid audience");
        }
        if (new Date().after(claimsSet.getExpirationTime())) {
            throw new JWTAuthorizationGrantsException("Expired claims");
        }
        return true;
    }

    private Optional<JWTClaimsSet> jwtClaimsSet(OpenIDClient openIDClient, JWTAuthentication jwtAuthentication) throws IOException, BadJOSEException, CertificateException, ParseException, JOSEException {
        SignedJWT clientAssertion = jwtAuthentication.getClientAssertion();
        if (jwtAuthentication instanceof ClientSecretJWT) {
            MACVerifier macVerifier = new MACVerifier(openIDClient.getClientSecretJWT());
            return clientAssertion.verify((JWSVerifier)macVerifier) ? Optional.of(clientAssertion.getJWTClaimsSet()) : Optional.empty();
        }
        return Optional.of(JWTRequest.claimsSet((OpenIDClient)openIDClient, (SignedJWT)clientAssertion));
    }

    private ResponseEntity handleAuthorizationCodeGrant(AuthorizationCodeGrant authorizationCodeGrant, OpenIDClient client) {
        String code = authorizationCodeGrant.getAuthorizationCode().getValue();
        MDCContext.mdcContext((String[])new String[]{"code", "code"});
        AuthorizationCode authorizationCode = this.concurrentAuthorizationCodeRepository.findByCodeNotAlreadyUsedAndMarkAsUsed(code);
        if (authorizationCode == null) {
            AuthorizationCode byCode = this.authorizationCodeRepository.findByCode(code);
            this.accessTokenRepository.deleteByAuthorizationCodeId(byCode.getId());
            throw new UnauthorizedException("Authorization code already used");
        }
        if (!authorizationCode.getClientId().equals(client.getClientId())) {
            throw new UnauthorizedException("Client is not authorized for the authorization code");
        }
        if (authorizationCodeGrant.getRedirectionURI() != null && !authorizationCodeGrant.getRedirectionURI().toString().equals(authorizationCode.getRedirectUri())) {
            throw new RedirectMismatchException("Redirects do not match");
        }
        if (authorizationCode.isRedirectURIProvided() && authorizationCodeGrant.getRedirectionURI() == null) {
            throw new RedirectMismatchException("Redirect URI is mandatory if specified in code request");
        }
        if (authorizationCode.isExpired(Clock.systemDefaultZone())) {
            throw new UnauthorizedException("Authorization code expired");
        }
        CodeVerifier codeVerifier = authorizationCodeGrant.getCodeVerifier();
        String codeChallenge = authorizationCode.getCodeChallenge();
        if (codeVerifier != null) {
            if (codeChallenge == null) {
                throw new CodeVerifierMissingException("code_verifier present, but no code_challenge in the authorization_code");
            }
            CodeChallengeMethod codeChallengeMethod = CodeChallengeMethod.parse((String)authorizationCode.getCodeChallengeMethod());
            CodeChallenge computed = CodeChallenge.compute((CodeChallengeMethod)codeChallengeMethod, (CodeVerifier)codeVerifier);
            if (!MessageDigest.isEqual(codeChallenge.getBytes(), computed.getValue().getBytes())) {
                LOG.error((Object)String.format("CodeVerifier %s with method %s does not match codeChallenge %s. Expected codeChallenge is %s", codeVerifier.getValue(), codeChallengeMethod, codeChallenge, computed.getValue()));
                throw new CodeVerifierMissingException("code_verifier does not match code_challenge");
            }
        }
        User user = this.userRepository.findUserBySub(authorizationCode.getSub());
        MDCContext.mdcContext((User)user, (String[])new String[0]);
        LOG.debug((Object)("Deleting user " + user.getSub()));
        this.userRepository.delete((Object)user);
        Map body = this.tokenEndpointResponse(Optional.of(user), client, authorizationCode.getScopes(), authorizationCode.getIdTokenClaims(), false, authorizationCode.getNonce(), Optional.of(authorizationCode.getAuthTime()), Optional.of(authorizationCode.getId()));
        return new ResponseEntity((Object)body, (MultiValueMap)this.responseHttpHeaders, HttpStatus.OK);
    }

    private ResponseEntity handleRefreshCodeGrant(RefreshTokenGrant refreshTokenGrant, OpenIDClient client) throws ParseException {
        String refreshTokenValue = refreshTokenGrant.getRefreshToken().getValue();
        Optional optionalSignedJWT = this.tokenGenerator.parseAndValidateSignedJWT(refreshTokenValue);
        if (!optionalSignedJWT.isPresent()) {
            throw new UnauthorizedException("Invalid refresh_token value");
        }
        SignedJWT signedJWT = (SignedJWT)optionalSignedJWT.get();
        String jwtId = signedJWT.getJWTClaimsSet().getJWTID();
        RefreshToken refreshToken = (RefreshToken)this.refreshTokenRepository.findByJwtId(jwtId).orElseThrow(() -> new IllegalArgumentException("RefreshToken not found"));
        if (!refreshToken.getClientId().equals(client.getClientId())) {
            throw new UnauthorizedException("Client is not authorized for the refresh token");
        }
        if (refreshToken.isExpired(Clock.systemDefaultZone())) {
            throw new UnauthorizedException("Refresh token expired");
        }
        this.refreshTokenRepository.delete((Object)refreshToken);
        Optional accessToken = this.accessTokenRepository.findById((Object)refreshToken.getAccessTokenId());
        accessToken.ifPresent(token -> this.accessTokenRepository.delete(token));
        Optional<User> optionalUser = refreshToken.isClientCredentials() ? Optional.empty() : Optional.of(this.tokenGenerator.decryptAccessTokenWithEmbeddedUserInfo(signedJWT));
        Map body = this.tokenEndpointResponse(optionalUser, client, refreshToken.getScopes(), Collections.emptyList(), false, null, optionalUser.map(User::getUpdatedAt), Optional.empty());
        return new ResponseEntity((Object)body, (MultiValueMap)this.responseHttpHeaders, HttpStatus.OK);
    }

    private ResponseEntity handleClientCredentialsGrant(OpenIDClient client) {
        Map body = this.tokenEndpointResponse(Optional.empty(), client, client.getScopes().stream().map(Scope::getName).collect(Collectors.toList()), Collections.emptyList(), true, null, Optional.empty(), Optional.empty());
        LOG.debug((Object)("Returning client_credentials access_token for RS " + client.getClientId()));
        return new ResponseEntity((Object)body, (MultiValueMap)this.responseHttpHeaders, HttpStatus.OK);
    }

    private Map<String, Object> tokenEndpointResponse(Optional<User> user, OpenIDClient client, List<String> scopes, List<String> idTokenClaims, boolean clientCredentials, String nonce, Optional<Long> authorizationTime, Optional<String> authorizationCodeId) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        EncryptedTokenValue encryptedAccessToken = user.map(u -> this.tokenGenerator.generateAccessTokenWithEmbeddedUserInfo(u, client)).orElse(this.tokenGenerator.generateAccessToken(client));
        String sub = user.map(User::getSub).orElse(client.getClientId());
        String unspecifiedUrnHash = user.map(u -> KeyGenerator.oneWayHash((String)u.getUnspecifiedNameId(), (String)this.salt)).orElse(null);
        AccessToken accessToken = new AccessToken(encryptedAccessToken.getJwtId(), sub, client.getClientId(), scopes, encryptedAccessToken.getKeyId(), this.accessTokenValidity(client), !user.isPresent(), (String)authorizationCodeId.orElse(null), unspecifiedUrnHash);
        accessToken = (AccessToken)this.accessTokenRepository.insert((Object)accessToken);
        map.put("access_token", encryptedAccessToken.getValue());
        map.put("token_type", "Bearer");
        if (client.getGrants().contains(GrantType.REFRESH_TOKEN.getValue())) {
            EncryptedTokenValue encryptedRefreshToken = user.map(u -> this.tokenGenerator.generateRefreshTokenWithEmbeddedUserInfo(u, client)).orElse(this.tokenGenerator.generateRefreshToken(client));
            String refreshTokenValue = encryptedRefreshToken.getValue();
            this.refreshTokenRepository.insert((Object)new RefreshToken(encryptedRefreshToken.getJwtId(), accessToken, this.refreshTokenValidity(client)));
            map.put("refresh_token", refreshTokenValue);
        }
        map.put("expires_in", client.getAccessTokenValidity());
        if (this.isOpenIDRequest(scopes) && !clientCredentials) {
            TokenValue tokenValue = this.tokenGenerator.generateIDTokenForTokenEndpoint(user, client, nonce, idTokenClaims, authorizationTime);
            map.put("id_token", tokenValue.getValue());
        }
        return map;
    }

    private HttpHeaders getResponseHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cache-Control", "no-store");
        headers.set("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        headers.set("Pragma", "no-cache");
        return headers;
    }
}

