/*
 * Decompiled with CFR 0.152.
 */
package oidc.saml;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oidc.model.AuthenticationRequest;
import oidc.model.User;
import oidc.repository.AuthenticationRequestRepository;
import oidc.repository.UserRepository;
import oidc.user.OidcSamlAuthentication;
import oidc.user.UserAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.Resource;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlAuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ResponseAuthenticationConverter
implements Converter<OpenSamlAuthenticationProvider.ResponseToken, OidcSamlAuthentication> {
    private static final Log LOG = LogFactory.getLog(ResponseAuthenticationConverter.class);
    private static final Pattern inResponseToPattern = Pattern.compile("InResponseTo=\"(.+?)\"", 32);
    private UserRepository userRepository;
    private List<UserAttribute> userAttributes;
    private final AuthenticationRequestRepository authenticationRequestRepository;

    public ResponseAuthenticationConverter(UserRepository userRepository, AuthenticationRequestRepository authenticationRequestRepository, ObjectMapper objectMapper, Resource oidcSamlMapping) throws IOException {
        this.userRepository = userRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userAttributes = (List)objectMapper.readValue(oidcSamlMapping.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public OidcSamlAuthentication convert(OpenSamlAuthenticationProvider.ResponseToken responseToken) {
        Saml2Authentication authentication = (Saml2Authentication)OpenSamlAuthenticationProvider.createDefaultResponseAuthenticationConverter().convert((Object)responseToken);
        Assertion assertion = (Assertion)responseToken.getResponse().getAssertions().get(0);
        Matcher matcher = inResponseToPattern.matcher(authentication.getSaml2Response());
        boolean match = matcher.find();
        if (!match) {
            throw new SessionAuthenticationException("Invalid Authn Statement. Missing InResponseTo");
        }
        String authenticationRequestID = matcher.group(1);
        User user = this.buildUser(assertion, authenticationRequestID);
        Optional existingUserOptional = this.userRepository.findOptionalUserBySub(user.getSub());
        if (existingUserOptional.isPresent()) {
            User existingUser = (User)existingUserOptional.get();
            LOG.debug((Object)("Authenticate with existing user: " + existingUser));
            user.setId(existingUser.getId());
            if (!user.equals((Object)existingUser)) {
                LOG.debug((Object)("Saving existing user with changed attributes: " + existingUser));
                this.userRepository.save((Object)existingUser);
            }
        } else {
            LOG.debug((Object)("Provisioning new user : " + user));
            this.userRepository.insert((Object)user);
        }
        OidcSamlAuthentication oidcSamlAuthentication = new OidcSamlAuthentication(assertion, user, authenticationRequestID);
        return oidcSamlAuthentication;
    }

    private User buildUser(Assertion assertion, String authenticationRequestID) {
        String unspecifiedNameId = assertion.getSubject().getNameID().getValue();
        List authnStatements = assertion.getAuthnStatements();
        AtomicReference authenticatingAuthority = new AtomicReference();
        if (!CollectionUtils.isEmpty((Collection)authnStatements)) {
            authnStatements.stream().map(as -> as.getAuthnContext().getAuthenticatingAuthorities()).flatMap(Collection::stream).findAny().ifPresent(aa -> authenticatingAuthority.set(aa.getURI()));
        }
        Map<String, Object> attributes = this.userAttributes.stream().filter(ua -> !ua.customMapping).map(ua -> new Object[]{ua.oidc, ua.multiValue ? this.getAttributeValues(ua.saml, assertion) : this.getAttributeValue(ua.saml, assertion)}).filter(oo -> oo[1] != null).collect(Collectors.toMap(oo -> (String)oo[0], oo -> oo[1]));
        this.addDerivedAttributes(attributes);
        String eduPersonTargetedId = this.getAttributeValue("urn:mace:dir:attribute-def:eduPersonTargetedID", assertion);
        AuthenticationRequest authenticationRequest = (AuthenticationRequest)this.authenticationRequestRepository.findById((Object)authenticationRequestID).orElseThrow(() -> new IllegalArgumentException("No Authentication Request found for ID: " + authenticationRequestID));
        String clientId = authenticationRequest.getClientId();
        String sub = StringUtils.hasText((String)eduPersonTargetedId) ? eduPersonTargetedId : UUID.nameUUIDFromBytes((unspecifiedNameId + "_" + clientId).getBytes()).toString();
        attributes.put("sub", sub);
        List acrClaims = assertion.getAuthnStatements().stream().map(authenticationStatement -> this.authenticationContextClassReference(authenticationStatement.getAuthnContext().getAuthnContextClassRef())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return new User(sub, unspecifiedNameId, (String)authenticatingAuthority.get(), clientId, attributes, acrClaims);
    }

    private void addDerivedAttributes(Map<String, Object> attributes) {
        if (attributes.containsKey("email")) {
            attributes.put("email_verified", true);
        }
    }

    private Optional<String> authenticationContextClassReference(AuthnContextClassRef authnContextClassRef) {
        return Optional.ofNullable(authnContextClassRef).map(AuthnContextClassRef::getAuthnContextClassRef);
    }

    private String getAttributeValue(String samlAttributeName, Assertion assertion) {
        List values = this.getAttributeValues(samlAttributeName, assertion);
        return !CollectionUtils.isEmpty((Collection)values) ? (String)values.get(0) : null;
    }

    private List<String> getAttributeValues(String samlAttributeName, Assertion assertion) {
        Optional<List> values = assertion.getAttributeStatements().stream().map(AttributeStatement::getAttributes).flatMap(Collection::stream).filter(attribute -> attribute.getName().equals(samlAttributeName)).findAny().map(attribute -> attribute.getAttributeValues().stream().map(xmlObject -> this.getXmlObjectValue(xmlObject)).filter(Objects::nonNull).map(val -> val.toString()).collect(Collectors.toList()));
        return values.orElse(null);
    }

    private Object getXmlObjectValue(XMLObject xmlObject) {
        if (xmlObject instanceof XSAny) {
            return ((XSAny)xmlObject).getTextContent();
        }
        if (xmlObject instanceof XSString) {
            return ((XSString)xmlObject).getValue();
        }
        if (xmlObject instanceof XSInteger) {
            return ((XSInteger)xmlObject).getValue();
        }
        if (xmlObject instanceof XSURI) {
            return ((XSURI)xmlObject).getValue();
        }
        if (xmlObject instanceof XSBoolean) {
            XSBooleanValue xsBooleanValue = ((XSBoolean)xmlObject).getValue();
            return xsBooleanValue != null ? xsBooleanValue.getValue() : null;
        }
        if (xmlObject instanceof XSDateTime) {
            DateTime dateTime = ((XSDateTime)xmlObject).getValue();
            return dateTime != null ? Instant.ofEpochMilli(dateTime.getMillis()) : null;
        }
        return null;
    }
}

