/*
 * Decompiled with CFR 0.152.
 */
package oidc.secure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.JsonKeysetReader;
import com.google.crypto.tink.JsonKeysetWriter;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.aead.AeadConfig;
import com.google.crypto.tink.aead.AesCtrHmacAeadKeyManager;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.claims.AccessTokenHash;
import com.nimbusds.openid.connect.sdk.claims.CodeHash;
import com.nimbusds.openid.connect.sdk.claims.StateHash;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import oidc.endpoints.MapTypeReference;
import oidc.model.EncryptedTokenValue;
import oidc.model.OpenIDClient;
import oidc.model.SigningKey;
import oidc.model.SymmetricKey;
import oidc.model.TokenValue;
import oidc.model.User;
import oidc.repository.SequenceRepository;
import oidc.repository.SigningKeyRepository;
import oidc.repository.SymmetricKeyRepository;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class TokenGenerator
implements MapTypeReference,
ApplicationListener<ApplicationStartedEvent> {
    public static final JWSAlgorithm signingAlg = JWSAlgorithm.RS256;
    public static final Instant instant = Instant.parse("2100-01-01T00:00:00.00Z");
    private static final char[] DEFAULT_CODEC = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private final Random random = new SecureRandom();
    private final String issuer;
    private Map<String, JWSSigner> signers;
    private Map<String, JWSVerifier> verifiers;
    private String currentSigningKeyId;
    private List<RSAKey> publicKeys;
    private final byte[] associatedData;
    private final KeysetHandle primaryKeysetHandle;
    private Map<String, KeysetHandle> keysetHandleMap;
    private String currentSymmetricKeyId;
    private final ObjectMapper objectMapper;
    private final Clock clock;
    private final SigningKeyRepository signingKeyRepository;
    private final SymmetricKeyRepository symmetricKeyRepository;
    private final SequenceRepository sequenceRepository;
    private final String defaultAcrValue;

    @Autowired
    public TokenGenerator(@Value(value="${sp.entity_id}") String issuer, @Value(value="${secret_key_set_path}") Resource secretKeySetPath, @Value(value="${associated_data}") String associatedData, @Value(value="${openid_configuration_path}") Resource configurationPath, @Value(value="${default_acr_value}") String defaultAcrValue, ObjectMapper objectMapper, SigningKeyRepository signingKeyRepository, SequenceRepository sequenceRepository, SymmetricKeyRepository symmetricKeyRepository, Environment environment) throws IOException, GeneralSecurityException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        AeadConfig.register();
        this.signingKeyRepository = signingKeyRepository;
        this.sequenceRepository = sequenceRepository;
        this.symmetricKeyRepository = symmetricKeyRepository;
        this.issuer = issuer;
        this.objectMapper = objectMapper;
        this.clock = environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"})) ? Clock.fixed(instant, ZoneId.systemDefault()) : Clock.systemDefaultZone();
        this.primaryKeysetHandle = CleartextKeysetHandle.read((KeysetReader)JsonKeysetReader.withInputStream((InputStream)secretKeySetPath.getInputStream()));
        this.associatedData = associatedData.getBytes(Charset.defaultCharset());
        Map wellKnownConfiguration = (Map)objectMapper.readValue(configurationPath.getInputStream(), mapTypeReference);
        this.defaultAcrValue = defaultAcrValue;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        this.initializeSymmetricKeys();
        this.initializeSigningKeys();
    }

    private void initializeSigningKeys() throws GeneralSecurityException, ParseException, IOException {
        List<Object> rsaKeys = this.signingKeyRepository.findAllByOrderByCreatedDesc().stream().filter(signingKey -> StringUtils.hasText((String)signingKey.getSymmetricKeyId())).map(arg_0 -> this.parseEncryptedRsaKey(arg_0)).collect(Collectors.toList());
        if (rsaKeys.isEmpty()) {
            SigningKey signingKey2 = this.generateEncryptedRsaKey();
            this.signingKeyRepository.save((Object)signingKey2);
            RSAKey rsaKey = this.parseEncryptedRsaKey(signingKey2);
            rsaKeys = Collections.singletonList(rsaKey);
        }
        this.publicKeys = rsaKeys.stream().map(RSAKey::toPublicJWK).collect(Collectors.toList());
        this.currentSigningKeyId = ((RSAKey)rsaKeys.get(0)).getKeyID();
        this.signers = rsaKeys.stream().collect(Collectors.toMap(JWK::getKeyID, arg_0 -> this.createRSASigner(arg_0)));
        this.verifiers = rsaKeys.stream().collect(Collectors.toMap(JWK::getKeyID, arg_0 -> this.createRSAVerifier(arg_0)));
    }

    public SigningKey rolloverSigningKeys() throws GeneralSecurityException, ParseException, IOException {
        SigningKey signingKey = this.generateEncryptedRsaKey();
        this.signingKeyRepository.save((Object)signingKey);
        this.initializeSigningKeys();
        return signingKey;
    }

    private void initializeSymmetricKeys() throws GeneralSecurityException, IOException {
        List<Object> keysetHandles = this.symmetricKeyRepository.findAllByOrderByCreatedDesc().stream().map(arg_0 -> this.parseKeysetHandle(arg_0)).collect(Collectors.toList());
        if (keysetHandles.isEmpty()) {
            this.signingKeyRepository.deleteAll();
            SymmetricKey symmetricKey = this.generateSymmetricKey();
            keysetHandles = Collections.singletonList(this.parseKeysetHandle(symmetricKey));
        }
        this.currentSymmetricKeyId = String.valueOf(((KeysetHandle)keysetHandles.get(0)).getKeysetInfo().getPrimaryKeyId());
        this.keysetHandleMap = keysetHandles.stream().collect(Collectors.toMap(keysetHandle -> String.valueOf(keysetHandle.getKeysetInfo().getPrimaryKeyId()), keysetHandle -> keysetHandle));
    }

    private SymmetricKey generateSymmetricKey() throws GeneralSecurityException, IOException {
        KeyTemplate keyTemplate = AesCtrHmacAeadKeyManager.aes256CtrHmacSha256Template();
        KeysetHandle keysetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Aead primitive = (Aead)this.primaryKeysetHandle.getPrimitive(Aead.class);
        keysetHandle.write(JsonKeysetWriter.withOutputStream((OutputStream)outputStream), primitive);
        int primaryKeyId = keysetHandle.getKeysetInfo().getPrimaryKeyId();
        String newKeyId = String.valueOf(primaryKeyId);
        this.sequenceRepository.updateSymmetricKeyId(newKeyId);
        String aead = Base64.getEncoder().encodeToString(outputStream.toString().getBytes(Charset.defaultCharset()));
        String keyId = newKeyId;
        SymmetricKey symmetricKey = new SymmetricKey(keyId, aead, new Date());
        this.symmetricKeyRepository.save((Object)symmetricKey);
        return symmetricKey;
    }

    public SymmetricKey rolloverSymmetricKeys() throws GeneralSecurityException, IOException {
        SymmetricKey symmetricKey = this.generateSymmetricKey();
        this.initializeSymmetricKeys();
        return symmetricKey;
    }

    private RSAKey parseEncryptedRsaKey(SigningKey signingKey) {
        return RSAKey.parse((String)this.decryptAead(signingKey.getJwk(), signingKey.getSymmetricKeyId()));
    }

    private KeysetHandle parseKeysetHandle(SymmetricKey symmetricKey) {
        byte[] decoded = Base64.getDecoder().decode(symmetricKey.getAead());
        Aead primitive = (Aead)this.primaryKeysetHandle.getPrimitive(Aead.class);
        return KeysetHandle.read((KeysetReader)JsonKeysetReader.withBytes((byte[])decoded), (Aead)primitive);
    }

    public EncryptedTokenValue generateAccessToken(OpenIDClient client) {
        String currentSigningKeyId = this.ensureLatestSigningKey();
        TokenValue tokenValue = this.idToken(client, Optional.empty(), Collections.emptyMap(), Collections.emptyList(), false, currentSigningKeyId, true);
        return new EncryptedTokenValue(tokenValue, currentSigningKeyId);
    }

    public EncryptedTokenValue generateRefreshToken(OpenIDClient client) {
        String currentSigningKeyId = this.ensureLatestSigningKey();
        TokenValue tokenValue = this.idToken(client, Optional.empty(), Collections.emptyMap(), Collections.emptyList(), false, currentSigningKeyId, false);
        return new EncryptedTokenValue(tokenValue, currentSigningKeyId);
    }

    public String generateAuthorizationCode() {
        byte[] verifierBytes = new byte[12];
        this.random.nextBytes(verifierBytes);
        char[] chars = new char[verifierBytes.length];
        for (int i = 0; i < verifierBytes.length; ++i) {
            chars[i] = DEFAULT_CODEC[this.random.nextInt(DEFAULT_CODEC.length)];
        }
        return new String(chars);
    }

    public EncryptedTokenValue generateAccessTokenWithEmbeddedUserInfo(User user, OpenIDClient client) {
        String currentSigningKeyId = this.ensureLatestSigningKey();
        TokenValue tokenValue = this.doGenerateAccessTokenWithEmbeddedUser(user, client, currentSigningKeyId, true);
        return new EncryptedTokenValue(tokenValue, currentSigningKeyId);
    }

    public EncryptedTokenValue generateRefreshTokenWithEmbeddedUserInfo(User user, OpenIDClient client) {
        String currentSigningKeyId = this.ensureLatestSigningKey();
        return new EncryptedTokenValue(this.doGenerateAccessTokenWithEmbeddedUser(user, client, currentSigningKeyId, false), currentSigningKeyId);
    }

    private TokenValue doGenerateAccessTokenWithEmbeddedUser(User user, OpenIDClient client, String signingKey, boolean isAccessToken) throws IOException, JOSEException, GeneralSecurityException, ParseException {
        String json = this.objectMapper.writeValueAsString((Object)user);
        String currentSymmetricKeyId = this.ensureLatestSymmetricKey();
        String value = this.encryptAead(json, currentSymmetricKeyId);
        HashMap<String, String> additionalClaims = new HashMap<String, String>();
        additionalClaims.put("claims", value);
        additionalClaims.put("claim_key_id", currentSymmetricKeyId);
        return this.idToken(client, Optional.empty(), additionalClaims, Collections.emptyList(), true, signingKey, isAccessToken);
    }

    private String encryptAead(String s, String currentSymmetricKeyId) throws GeneralSecurityException, IOException {
        KeysetHandle keysetHandle = (KeysetHandle)this.safeGet(currentSymmetricKeyId, this.keysetHandleMap);
        Aead aead = (Aead)keysetHandle.getPrimitive(Aead.class);
        byte[] src = aead.encrypt(s.getBytes(Charset.defaultCharset()), this.associatedData);
        return Base64.getEncoder().encodeToString(src);
    }

    public Optional<SignedJWT> parseAndValidateSignedJWT(String accessToken) {
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)accessToken);
            String keyID = signedJWT.getHeader().getKeyID();
            this.ensureLatestSigningKey();
            JWSVerifier verifier = (JWSVerifier)this.safeGet(keyID, this.verifiers);
            if (!signedJWT.verify(verifier)) {
                throw new JOSEException("Tampered JWT");
            }
            return Optional.of(signedJWT);
        }
        catch (JOSEException | IOException | GeneralSecurityException | ParseException e) {
            return Optional.empty();
        }
    }

    public User decryptAccessTokenWithEmbeddedUserInfo(SignedJWT signedJWT) {
        if (!signedJWT.getState().equals((Object)JWSObject.State.VERIFIED)) {
            throw new JOSEException("JWT is not verified");
        }
        Map claims = signedJWT.getJWTClaimsSet().getClaims();
        String encryptedClaims = (String)claims.get("claims");
        String keyId = (String)claims.get("claim_key_id");
        String s = this.decryptAead(encryptedClaims, keyId);
        return (User)this.objectMapper.readValue(s, User.class);
    }

    private String decryptAead(String s, String symmetricKeyId) throws GeneralSecurityException, IOException {
        this.ensureLatestSymmetricKey();
        KeysetHandle keysetHandle = (KeysetHandle)this.safeGet(symmetricKeyId, this.keysetHandleMap);
        Aead aead = (Aead)keysetHandle.getPrimitive(Aead.class);
        byte[] decoded = Base64.getDecoder().decode(s);
        return new String(aead.decrypt(decoded, this.associatedData));
    }

    public TokenValue generateIDTokenForTokenEndpoint(Optional<User> user, OpenIDClient client, String nonce, List<String> idTokenClaims, Optional<Long> authorizationTime) {
        HashMap<String, String> additionalClaims = new HashMap<String, String>();
        authorizationTime.ifPresent(time -> additionalClaims.put("auth_time", (String)time));
        if (StringUtils.hasText((String)nonce)) {
            additionalClaims.put("nonce", nonce);
        }
        String currentSigningKeyId = this.ensureLatestSigningKey();
        return this.idToken(client, user, additionalClaims, idTokenClaims, false, currentSigningKeyId, true);
    }

    public TokenValue generateIDTokenForAuthorizationEndpoint(User user, OpenIDClient client, Nonce nonce, ResponseType responseType, String accessToken, List<String> claims, Optional<String> authorizationCode, State state) {
        HashMap<String, Object> additionalClaims = new HashMap<String, Object>();
        additionalClaims.put("auth_time", System.currentTimeMillis() / 1000L);
        if (nonce != null) {
            additionalClaims.put("nonce", nonce.getValue());
        }
        if (AccessTokenHash.isRequiredInIDTokenClaims((ResponseType)responseType)) {
            additionalClaims.put("at_hash", AccessTokenHash.compute((AccessToken)new BearerAccessToken(accessToken), (JWSAlgorithm)signingAlg).getValue());
        }
        if (CodeHash.isRequiredInIDTokenClaims((ResponseType)responseType) && authorizationCode.isPresent()) {
            additionalClaims.put("c_hash", CodeHash.compute((AuthorizationCode)new AuthorizationCode(authorizationCode.get()), (JWSAlgorithm)signingAlg));
        }
        if (state != null && StringUtils.hasText((String)state.getValue())) {
            additionalClaims.put("s_hash", StateHash.compute((State)state, (JWSAlgorithm)signingAlg));
        }
        String currentSigningKeyId = this.ensureLatestSigningKey();
        return this.idToken(client, Optional.of(user), additionalClaims, claims, false, currentSigningKeyId, true);
    }

    public List<JWK> getAllPublicKeys() throws GeneralSecurityException, ParseException, IOException {
        this.ensureLatestSigningKey();
        return new ArrayList<JWK>(this.publicKeys);
    }

    private RSAKey generateRsaKey(String keyID) throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(2048);
        KeyPair keyPair = kpg.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        return new RSAKey.Builder(publicKey).privateKey(privateKey).algorithm((Algorithm)signingAlg).keyID(keyID).build();
    }

    private SigningKey generateEncryptedRsaKey() throws GeneralSecurityException, IOException {
        String keyId = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS").format(new Date());
        this.sequenceRepository.updateSigningKeyId(keyId);
        RSAKey rsaKey = this.generateRsaKey(String.format("key_%s", keyId));
        String currentSymmetricKeyId = this.ensureLatestSymmetricKey();
        String value = this.encryptAead(rsaKey.toJSONString(), currentSymmetricKeyId);
        return new SigningKey(rsaKey.getKeyID(), currentSymmetricKeyId, value, new Date());
    }

    private TokenValue idToken(OpenIDClient client, Optional<User> optionalUser, Map<String, Object> additionalClaims, List<String> idTokenClaims, boolean includeAllowedResourceServers, String signingKey, boolean isAccessToken) throws JOSEException, GeneralSecurityException, ParseException, IOException {
        ArrayList<String> audiences = new ArrayList<String>();
        audiences.add(client.getClientId());
        if (includeAllowedResourceServers && isAccessToken) {
            audiences.addAll(client.getAllowedResourceServers().stream().filter(rsEntityId -> !client.getClientId().equals(rsEntityId)).collect(Collectors.toList()));
        }
        int tokenValidity = isAccessToken ? client.getAccessTokenValidity() : client.getRefreshTokenValidity();
        String jti = UUID.randomUUID().toString();
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().audience(audiences).expirationTime(Date.from(this.clock.instant().plus((long)tokenValidity, ChronoUnit.SECONDS))).jwtID(jti).issuer(this.issuer).issueTime(Date.from(this.clock.instant())).subject(optionalUser.map(User::getSub).orElse(client.getClientId())).notBeforeTime(new Date(System.currentTimeMillis()));
        if (!CollectionUtils.isEmpty(idTokenClaims) && optionalUser.isPresent() && isAccessToken) {
            User user2 = optionalUser.get();
            Map attributes = user2.getAttributes();
            idTokenClaims.forEach(claim -> {
                if (attributes.containsKey(claim)) {
                    builder.claim(claim, attributes.get(claim));
                }
            });
        }
        optionalUser.ifPresent(user -> {
            List acrClaims = user.getAcrClaims();
            if (CollectionUtils.isEmpty((Collection)acrClaims)) {
                builder.claim("acr", (Object)this.defaultAcrValue);
            } else {
                builder.claim("acr", (Object)String.join((CharSequence)" ", acrClaims));
            }
        });
        additionalClaims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
        JWTClaimsSet claimsSet = builder.build();
        JWSHeader header = new JWSHeader.Builder(signingAlg).type(JOSEObjectType.JWT).keyID(signingKey).build();
        SignedJWT signedJWT = new SignedJWT(header, claimsSet);
        this.ensureLatestSigningKey();
        JWSSigner jswsSigner = (JWSSigner)this.safeGet(signingKey, this.signers);
        signedJWT.sign(jswsSigner);
        return new TokenValue(signedJWT.serialize(), jti);
    }

    private String ensureLatestSigningKey() throws GeneralSecurityException, ParseException, IOException {
        if (!this.sequenceRepository.currentSigningKeyId().equals(this.currentSigningKeyId)) {
            this.initializeSigningKeys();
        }
        return this.currentSigningKeyId;
    }

    private String ensureLatestSymmetricKey() throws GeneralSecurityException, IOException {
        if (!this.sequenceRepository.currentSymmetricKeyId().equals(this.currentSymmetricKeyId)) {
            this.initializeSymmetricKeys();
        }
        return this.currentSymmetricKeyId;
    }

    private RSASSASigner createRSASigner(RSAKey k) {
        return new RSASSASigner(k);
    }

    private RSASSAVerifier createRSAVerifier(RSAKey k) {
        return new RSASSAVerifier(k);
    }

    private <T> T safeGet(String k, Map<String, T> map) {
        T t = map.get(k);
        if (t == null) {
            throw new IllegalArgumentException(String.format("Map with keys %s does not contain key %s", map.keySet(), k));
        }
        return t;
    }
}

