/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oidc.crypto.KeyGenerator;
import oidc.endpoints.OidcEndpoint;
import oidc.exceptions.InvalidGrantException;
import oidc.exceptions.InvalidScopeException;
import oidc.exceptions.RedirectMismatchException;
import oidc.exceptions.UnsupportedPromptValueException;
import oidc.log.MDCContext;
import oidc.model.AccessToken;
import oidc.model.AuthorizationCode;
import oidc.model.EncryptedTokenValue;
import oidc.model.OpenIDClient;
import oidc.model.ProvidedRedirectURI;
import oidc.model.TokenValue;
import oidc.model.User;
import oidc.model.UserConsent;
import oidc.repository.AccessTokenRepository;
import oidc.repository.AuthorizationCodeRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.repository.UserConsentRepository;
import oidc.repository.UserRepository;
import oidc.secure.JWTRequest;
import oidc.secure.TokenGenerator;
import oidc.user.OidcSamlAuthentication;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class AuthorizationEndpoint
implements OidcEndpoint {
    private static final Log LOG = LogFactory.getLog(AuthorizationEndpoint.class);
    private static final List<String> forFreeOpenIDScopes = Arrays.asList("profile", "email", "address", "phone");
    private final TokenGenerator tokenGenerator;
    private final AuthorizationCodeRepository authorizationCodeRepository;
    private final AccessTokenRepository accessTokenRepository;
    private final UserRepository userRepository;
    private final UserConsentRepository userConsentRepository;
    private final OpenIDClientRepository openIDClientRepository;
    private final String salt;
    private static final String unsupportedPromptMessage = "Unsupported Prompt value";

    @Autowired
    public AuthorizationEndpoint(AuthorizationCodeRepository authorizationCodeRepository, AccessTokenRepository accessTokenRepository, UserRepository userRepository, UserConsentRepository userConsentRepository, OpenIDClientRepository openIDClientRepository, TokenGenerator tokenGenerator, @Value(value="${access_token_one_way_hash_salt}") String salt) {
        this.authorizationCodeRepository = authorizationCodeRepository;
        this.accessTokenRepository = accessTokenRepository;
        this.userRepository = userRepository;
        this.userConsentRepository = userConsentRepository;
        this.openIDClientRepository = openIDClientRepository;
        this.tokenGenerator = tokenGenerator;
        this.salt = salt;
    }

    @GetMapping(value={"/oidc/authorize"})
    public ModelAndView authorize(@RequestParam MultiValueMap<String, String> parameters, Authentication authentication, HttpServletRequest request) throws com.nimbusds.oauth2.sdk.ParseException, JOSEException, IOException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, BadJOSEException, ParseException, URISyntaxException {
        LOG.debug((Object)String.format("/oidc/authorize %s %s", authentication.getDetails(), parameters));
        return this.doAuthorization(parameters, (OidcSamlAuthentication)authentication, request, false, false);
    }

    @PostMapping(value={"/oidc/consent"}, consumes={"application/x-www-form-urlencoded"})
    public ModelAndView consent(@RequestParam Map<String, String> body, Authentication authentication, HttpServletRequest request) throws com.nimbusds.oauth2.sdk.ParseException, JOSEException, IOException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, BadJOSEException, ParseException, URISyntaxException {
        LOG.debug((Object)String.format("/oidc/consent %s %s", authentication.getDetails(), body));
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.setAll(body);
        return this.doAuthorization((MultiValueMap)parameters, (OidcSamlAuthentication)authentication, request, false, true);
    }

    private ModelAndView doAuthorization(MultiValueMap<String, String> parameters, OidcSamlAuthentication samlAuthentication, HttpServletRequest request, boolean consentRequired, boolean createConsent) throws com.nimbusds.oauth2.sdk.ParseException, CertificateException, JOSEException, IOException, BadJOSEException, ParseException, URISyntaxException, NoSuchProviderException, NoSuchAlgorithmException {
        boolean consentFromPrompt;
        AuthorizationRequest authenticationRequest = AuthorizationRequest.parse(parameters);
        Scope scope = authenticationRequest.getScope();
        boolean isOpenIdClient = scope != null && this.isOpenIDRequest(scope.toStringList());
        OpenIDClient client = this.openIDClientRepository.findByClientId(authenticationRequest.getClientID().getValue());
        MDCContext.mdcContext((String[])new String[]{"action", "Authorize", "rp", client.getClientId()});
        if (isOpenIdClient) {
            AuthenticationRequest oidcAuthenticationRequest = AuthenticationRequest.parse(parameters);
            if (oidcAuthenticationRequest.specifiesRequestObject()) {
                oidcAuthenticationRequest = JWTRequest.parse((AuthenticationRequest)oidcAuthenticationRequest, (OpenIDClient)client);
                LOG.debug((Object)"/oidc/authorize with JWT 'request'");
            }
            authenticationRequest = oidcAuthenticationRequest;
        }
        State state = authenticationRequest.getState();
        String redirectURI = AuthorizationEndpoint.validateRedirectionURI((AuthorizationRequest)authenticationRequest, (OpenIDClient)client).getRedirectURI();
        List scopes = AuthorizationEndpoint.validateScopes((AuthorizationRequest)authenticationRequest, (OpenIDClient)client);
        ResponseType responseType = AuthorizationEndpoint.validateGrantType((AuthorizationRequest)authenticationRequest, (OpenIDClient)client);
        User user = samlAuthentication.getUser();
        MDCContext.mdcContext((User)user, (String[])new String[0]);
        Prompt prompt = authenticationRequest.getPrompt();
        boolean bl = consentFromPrompt = prompt != null && prompt.toStringList().contains("consent");
        if (consentRequired && (consentFromPrompt || client.isConsentRequired())) {
            boolean userConsentRequired;
            Optional userConsentOptional = this.userConsentRepository.findUserConsentBySub(user.getSub());
            boolean bl2 = userConsentRequired = consentFromPrompt || userConsentOptional.map(userConsent -> userConsent.renewConsentRequired(user, scopes)).orElse(true) != false;
            if (userConsentRequired) {
                LOG.debug((Object)("Asking for consent for User " + user + " and scopes " + scopes));
                return this.doConsent(parameters, client, scopes, user);
            }
        }
        if (createConsent) {
            this.createConsent(scopes, user, client);
        }
        this.logout(request);
        ResponseMode responseMode = authenticationRequest.impliedResponseMode();
        if (responseType.impliesCodeFlow()) {
            AuthorizationCode authorizationCode = this.createAndSaveAuthorizationCode(authenticationRequest, client, user);
            LOG.debug((Object)String.format("Returning authorizationCode flow %s %s", ResponseMode.FORM_POST, redirectURI));
            if (responseMode.equals((Object)ResponseMode.FORM_POST)) {
                HashMap<String, String> body = new HashMap<String, String>();
                body.put("redirect_uri", redirectURI);
                body.put("code", authorizationCode.getCode());
                if (state != null && StringUtils.hasText((String)state.getValue())) {
                    body.put("state", state.getValue());
                }
                return new ModelAndView("form_post", body);
            }
            return new ModelAndView((View)new RedirectView(this.authorizationRedirect(redirectURI, state, authorizationCode.getCode(), responseMode.equals((Object)ResponseMode.FRAGMENT))));
        }
        if (responseType.impliesImplicitFlow() || responseType.impliesHybridFlow()) {
            if (responseType.impliesImplicitFlow()) {
                LOG.debug((Object)("Deleting user " + user.getSub()));
                this.userRepository.delete((Object)user);
            }
            Map body = this.authorizationEndpointResponse(user, client, authenticationRequest, scopes, responseType, state);
            LOG.debug((Object)String.format("Returning implicit flow %s %s", ResponseMode.FORM_POST, redirectURI));
            if (responseMode.equals((Object)ResponseMode.FORM_POST)) {
                body.put("redirect_uri", redirectURI);
                return new ModelAndView("form_post", body);
            }
            if (responseMode.equals((Object)ResponseMode.QUERY)) {
                UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectURI);
                body.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
                return new ModelAndView((View)new RedirectView(builder.toUriString()));
            }
            if (responseMode.equals((Object)ResponseMode.FRAGMENT)) {
                UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectURI);
                String fragment = body.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
                builder.fragment(fragment);
                return new ModelAndView((View)new RedirectView(builder.toUriString()));
            }
            throw new IllegalArgumentException("Response mode " + responseMode + " not supported");
        }
        throw new IllegalArgumentException("Not yet implemented response_type: " + responseType.toString());
    }

    private void logout(HttpServletRequest request) {
        SecurityContextHolder.getContext().setAuthentication(null);
        SecurityContextHolder.clearContext();
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    private void createConsent(List<String> scopes, User user, OpenIDClient openIDClient) {
        LOG.info((Object)("Creating consent for User " + user + " and scopes " + scopes));
        UserConsent userConsent = this.userConsentRepository.findUserConsentBySub(user.getSub()).map(uc -> uc.updateHash(user, scopes)).orElse(new UserConsent(user, scopes, openIDClient));
        this.userConsentRepository.save((Object)userConsent);
    }

    private ModelAndView doConsent(MultiValueMap<String, String> parameters, OpenIDClient client, List<String> scopes, User user) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("parameters", parameters.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)((List)entry.getValue()).get(0))));
        String authenticatingAuthority = user.getAuthenticatingAuthority();
        body.put("scopes", client.getScopes().stream().filter(scope -> scopes.contains(scope.getName())).collect(Collectors.toList()));
        body.put("client", client.getName());
        List allowedResourceServers = client.getAllowedResourceServers();
        List resourceServers = this.openIDClientRepository.findByClientIdIn(allowedResourceServers);
        Map<String, String> audiences = allowedResourceServers.stream().collect(Collectors.toMap(name -> name, name -> resourceServers.stream().filter(rs -> rs.getClientId().equals(name)).findFirst().map(OpenIDClient::getName).orElse((String)name)));
        body.put("audiences", audiences);
        Map attributes = user.getAttributes();
        Map<String, String> claims = attributes.keySet().stream().collect(Collectors.toMap(key -> key, key -> this.attributeValueForConsent(attributes.get(key))));
        body.put("claims", claims);
        body.put("email", attributes.get("email"));
        return new ModelAndView("consent", body);
    }

    private String attributeValueForConsent(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Collection) {
            return ((Collection)object).stream().collect(Collectors.joining(", ")).toString();
        }
        return object.toString();
    }

    public static ResponseType validateGrantType(AuthorizationRequest authorizationRequest, OpenIDClient client) {
        ResponseType responseType = authorizationRequest.getResponseType();
        List grants = client.getGrants();
        if ((responseType.impliesImplicitFlow() || responseType.impliesHybridFlow()) && !grants.contains(GrantType.IMPLICIT.getValue())) {
            throw new InvalidGrantException(String.format("Grant types %s does not allow for implicit / hybrid flow", grants));
        }
        if (responseType.impliesCodeFlow() && !grants.contains(GrantType.AUTHORIZATION_CODE.getValue())) {
            throw new InvalidGrantException(String.format("Grant types %s does not allow for authorization code flow", grants));
        }
        return responseType;
    }

    private Map<String, Object> authorizationEndpointResponse(User user, OpenIDClient client, AuthorizationRequest authorizationRequest, List<String> scopes, ResponseType responseType, State state) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        EncryptedTokenValue encryptedAccessToken = this.tokenGenerator.generateAccessTokenWithEmbeddedUserInfo(user, client);
        if (responseType.contains(ResponseType.Value.TOKEN.getValue()) || !this.isOpenIDRequest(authorizationRequest)) {
            String unspecifiedUrnHash = KeyGenerator.oneWayHash((String)user.getUnspecifiedNameId(), (String)this.salt);
            AccessToken accessToken = new AccessToken(encryptedAccessToken.getJwtId(), user.getSub(), client.getClientId(), scopes, encryptedAccessToken.getKeyId(), this.accessTokenValidity(client), false, null, unspecifiedUrnHash);
            this.accessTokenRepository.insert((Object)accessToken);
            result.put("access_token", encryptedAccessToken.getValue());
            result.put("token_type", "Bearer");
        }
        if (responseType.contains(ResponseType.Value.CODE.getValue())) {
            AuthorizationCode authorizationCode = this.createAndSaveAuthorizationCode(authorizationRequest, client, user);
            result.put("code", authorizationCode.getCode());
        }
        if (responseType.contains(OIDCResponseTypeValue.ID_TOKEN.getValue()) && this.isOpenIDRequest(scopes) && this.isOpenIDRequest(authorizationRequest)) {
            AuthenticationRequest authenticationRequest = (AuthenticationRequest)authorizationRequest;
            List claims = this.getClaims(authorizationRequest);
            TokenValue tokenValue = this.tokenGenerator.generateIDTokenForAuthorizationEndpoint(user, client, authenticationRequest.getNonce(), responseType, encryptedAccessToken.getValue(), claims, Optional.ofNullable((String)result.get("code")), state);
            result.put("id_token", tokenValue.getValue());
        }
        result.put("expires_in", client.getAccessTokenValidity());
        if (state != null) {
            result.put("state", state.getValue());
        }
        return result;
    }

    private AuthorizationCode createAndSaveAuthorizationCode(AuthorizationRequest authorizationRequest, OpenIDClient client, User user) {
        URI redirectionURI = authorizationRequest.getRedirectionURI();
        Scope scope = authorizationRequest.getScope();
        List scopes = scope != null ? scope.toStringList() : Collections.emptyList();
        CodeChallenge codeChallenge = authorizationRequest.getCodeChallenge();
        String codeChallengeValue = codeChallenge != null ? codeChallenge.getValue() : null;
        CodeChallengeMethod codeChallengeMethod = authorizationRequest.getCodeChallengeMethod();
        String codeChallengeMethodValue = codeChallengeMethod != null ? codeChallengeMethod.getValue() : (codeChallengeValue != null ? CodeChallengeMethod.getDefault().getValue() : null);
        List idTokenClaims = this.getClaims(authorizationRequest);
        String code = this.tokenGenerator.generateAuthorizationCode();
        Nonce nonce = authorizationRequest instanceof AuthenticationRequest ? ((AuthenticationRequest)AuthenticationRequest.class.cast(authorizationRequest)).getNonce() : null;
        AuthorizationCode authorizationCode = new AuthorizationCode(code, user.getSub(), client.getClientId(), scopes, redirectionURI, codeChallengeValue, codeChallengeMethodValue, nonce != null ? nonce.getValue() : null, idTokenClaims, redirectionURI != null, this.tokenValidity(600));
        this.authorizationCodeRepository.insert((Object)authorizationCode);
        return authorizationCode;
    }

    public static ProvidedRedirectURI validateRedirectionURI(AuthorizationRequest authenticationRequest, OpenIDClient client) throws UnsupportedEncodingException {
        URI redirectionURI = authenticationRequest.getRedirectionURI();
        List registeredRedirectUrls = client.getRedirectUrls();
        if (redirectionURI == null) {
            return registeredRedirectUrls.stream().findFirst().map(s -> new ProvidedRedirectURI(s, false)).orElseThrow(() -> new IllegalArgumentException(String.format("Client %s must have at least one redirectURI configured to use the Authorization flow", client.getClientId())));
        }
        String redirectURI = URLDecoder.decode(redirectionURI.toString(), "UTF-8");
        Optional<ProvidedRedirectURI> optionalProvidedRedirectURI = registeredRedirectUrls.stream().map(url -> new ProvidedRedirectURI(url, true)).filter(providedRedirectURI -> providedRedirectURI.equalsIgnorePort(redirectURI)).findFirst();
        if (!optionalProvidedRedirectURI.isPresent()) {
            throw new RedirectMismatchException(String.format("Client %s with registered redirect URI's %s requested authorization with redirectURI %s", client.getClientId(), registeredRedirectUrls, redirectURI));
        }
        return optionalProvidedRedirectURI.get();
    }

    private String authorizationRedirect(String redirectionURI, State state, String code, boolean isFragment) {
        boolean hasState;
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectionURI);
        boolean bl = hasState = state != null && StringUtils.hasText((String)state.getValue());
        if (isFragment) {
            String fragment = "code=" + code;
            if (hasState) {
                fragment = fragment.concat("&state=" + state.getValue());
            }
            builder.fragment(fragment);
        } else {
            builder.queryParam("code", new Object[]{code});
            if (hasState) {
                builder.queryParam("state", new Object[]{state.getValue()});
            }
        }
        return builder.toUriString();
    }

    public static String validatePrompt(Map<String, List<String>> request) throws com.nimbusds.oauth2.sdk.ParseException {
        List<String> promptValues = request.get("prompt");
        String promptValue = CollectionUtils.isEmpty(promptValues) ? null : promptValues.get(0);
        Prompt prompt = Prompt.parse((String)promptValue);
        return AuthorizationEndpoint.validatePrompt((Prompt)prompt);
    }

    public static String validatePrompt(Prompt prompt) {
        if (prompt != null) {
            List<String> allowedValues = Arrays.asList("consent", "login");
            prompt.toStringList().forEach(val -> {
                if (!allowedValues.contains(val)) {
                    throw new UnsupportedPromptValueException(AuthorizationEndpoint.unsupportedPromptValue((String)val), "Unsupported Prompt value");
                }
            });
        }
        return prompt != null ? prompt.toString() : null;
    }

    private static String unsupportedPromptValue(String prompt) {
        switch (prompt) {
            case "none": {
                return "interaction_required";
            }
            case "select_account": {
                return "account_selection_required";
            }
        }
        return "invalid_request";
    }

    public static List<String> validateScopes(AuthorizationRequest authorizationRequest, OpenIDClient client) {
        Scope scope = authorizationRequest.getScope();
        List requestedScopes = scope != null ? scope.toStringList() : Collections.emptyList();
        List scopes = client.getScopes().stream().map(oidc.model.Scope::getName).collect(Collectors.toList());
        scopes.addAll(forFreeOpenIDScopes);
        if (!scopes.containsAll(requestedScopes)) {
            List missingScopes = requestedScopes.stream().filter(s -> !scopes.contains(s)).collect(Collectors.toList());
            throw new InvalidScopeException(String.format("Scope(s) %s are not allowed for %s. Allowed scopes: %s", missingScopes, client.getClientId(), client.getScopes()));
        }
        return requestedScopes;
    }
}

