/*
 * Decompiled with CFR 0.152.
 */
package oidc.mongo;

import com.github.cloudyrock.mongock.ChangeLog;
import com.github.cloudyrock.mongock.ChangeSet;
import com.github.cloudyrock.mongock.driver.mongodb.springdata.v3.decorator.impl.MongockTemplate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oidc.model.AccessToken;
import oidc.model.AuthorizationCode;
import oidc.model.OpenIDClient;
import oidc.model.RefreshToken;
import oidc.model.SigningKey;
import oidc.model.SymmetricKey;
import oidc.model.User;
import oidc.model.UserConsent;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexOperations;

@ChangeLog(order="001")
public class MongoChangelog {
    @ChangeSet(order="001", id="createIndexes", author="Okke Harsta")
    public void createCollections(MongockTemplate mongoTemplate) {
        HashMap<Class, List<String>> indexInfo = new HashMap<Class, List<String>>();
        indexInfo.put(AccessToken.class, Collections.singletonList("value"));
        indexInfo.put(AuthorizationCode.class, Collections.singletonList("code"));
        indexInfo.put(User.class, Collections.singletonList("sub"));
        indexInfo.put(OpenIDClient.class, Collections.singletonList("clientId"));
        this.ensureCollectionsAndIndexes(mongoTemplate, indexInfo);
    }

    @ChangeSet(order="002", id="createSigningAndSymmetricKeyCollection", author="Okke Harsta")
    public void createSigningKeyCollection(MongockTemplate mongoTemplate) {
        if (!mongoTemplate.collectionExists("signing_keys")) {
            mongoTemplate.createCollection("signing_keys");
        }
        mongoTemplate.indexOps(SigningKey.class).ensureIndex((IndexDefinition)new Index("created", Sort.Direction.DESC));
        if (!mongoTemplate.collectionExists("symmetric_keys")) {
            mongoTemplate.createCollection("symmetric_keys");
        }
        mongoTemplate.indexOps(SymmetricKey.class).ensureIndex((IndexDefinition)new Index("created", Sort.Direction.DESC));
    }

    @ChangeSet(order="003", id="createUserConsentIndex", author="Okke Harsta")
    public void createUserConsent(MongockTemplate mongoTemplate) {
        mongoTemplate.dropCollection(UserConsent.class);
        HashMap<Class<UserConsent>, List<String>> indexInfo = new HashMap<Class<UserConsent>, List<String>>();
        indexInfo.put(UserConsent.class, Collections.singletonList("sub"));
        this.ensureCollectionsAndIndexes(mongoTemplate, indexInfo);
    }

    @ChangeSet(order="004", id="createIdentityProviders", author="Okke Harsta")
    public void createIdentityProviders(MongockTemplate mongoTemplate) {
        mongoTemplate.dropCollection("identity_providers");
    }

    @ChangeSet(order="005", id="removeAndRebuildRefreshTokenIndex", author="Okke Harsta")
    public void removeAndRebuildRefreshTokenIndex(MongockTemplate mongoTemplate) {
        mongoTemplate.indexOps(RefreshToken.class).ensureIndex((IndexDefinition)new Index("value", Sort.Direction.ASC).named(String.format("value_unique", new Object[0])).unique());
    }

    @ChangeSet(order="006", id="dropValueIndexes", author="Okke Harsta")
    public void dropValueIndexes(MongockTemplate mongoTemplate) {
        Arrays.asList("access_tokens", "refresh_tokens").forEach(collection -> {
            IndexOperations indexOperations = mongoTemplate.indexOps(collection);
            indexOperations.dropIndex("value_unique");
            indexOperations.ensureIndex((IndexDefinition)new Index("jwtId", Sort.Direction.ASC).unique());
        });
    }

    private void ensureCollectionsAndIndexes(MongockTemplate mongoTemplate, Map<Class<?>, List<String>> indexInfo) {
        this.ensureCollectionsAndIndexes(mongoTemplate, indexInfo, true);
    }

    private void ensureCollectionsAndIndexes(MongockTemplate mongoTemplate, Map<Class<?>, List<String>> indexInfo, boolean unique) {
        indexInfo.forEach((collection, fields) -> {
            if (!mongoTemplate.collectionExists(collection)) {
                mongoTemplate.createCollection(collection);
            }
            fields.forEach(field -> {
                IndexOperations indexOperations = mongoTemplate.indexOps(collection);
                Index index = new Index(field, Sort.Direction.ASC).named(String.format("%s_unique", field));
                index = unique ? index.unique() : index;
                indexOperations.ensureIndex((IndexDefinition)index);
            });
        });
    }
}

