/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import oidc.model.OpenIDClient;
import oidc.repository.OpenIDClientRepository;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;

public class ConsentEndpoint {
    private final OpenIDClientRepository openIDClientRepository;

    public ConsentEndpoint(OpenIDClientRepository openIDClientRepository) {
        this.openIDClientRepository = openIDClientRepository;
    }

    @GetMapping(value={"/consent"})
    public ModelAndView consent() {
        OpenIDClient rs = this.openIDClientRepository.findByClientId("mock-sp");
        OpenIDClient client = this.openIDClientRepository.findByClientId("playground_client");
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("resourceServers", Arrays.asList(rs));
        body.put("client", client);
        body.put("scopes", rs.getScopes());
        Locale locale = LocaleContextHolder.getLocale();
        body.put("lang", locale.getLanguage());
        return new ModelAndView("consent", body);
    }
}

