/*
 * Decompiled with CFR 0.152.
 */
package oidc.secure;

import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import oidc.model.AccessToken;
import oidc.model.AuthenticationRequest;
import oidc.model.AuthorizationCode;
import oidc.model.RefreshToken;
import oidc.model.User;
import oidc.model.UserConsent;
import oidc.repository.AccessTokenRepository;
import oidc.repository.AuthenticationRequestRepository;
import oidc.repository.AuthorizationCodeRepository;
import oidc.repository.RefreshTokenRepository;
import oidc.repository.UserConsentRepository;
import oidc.repository.UserRepository;
import oidc.secure.KeyRollover;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ResourceCleaner {
    private static Log LOG = LogFactory.getLog(ResourceCleaner.class);
    private KeyRollover keyRollover;
    private AccessTokenRepository accessTokenRepository;
    private RefreshTokenRepository refreshTokenRepository;
    private AuthorizationCodeRepository authorizationCodeRepository;
    private UserRepository userRepository;
    private UserConsentRepository userConsentRepository;
    private AuthenticationRequestRepository authenticationRequestRepository;
    private boolean cronJobResponsible;
    private long consentExpiryDurationDays;

    @Autowired
    public ResourceCleaner(AccessTokenRepository accessTokenRepository, RefreshTokenRepository refreshTokenRepository, AuthorizationCodeRepository authorizationCodeRepository, UserRepository userRepository, UserConsentRepository userConsentRepository, AuthenticationRequestRepository authenticationRequestRepository, KeyRollover keyRollover, @Value(value="${cron.consent-expiry-duration-days}") long consentExpiryDurationDays, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible) {
        this.accessTokenRepository = accessTokenRepository;
        this.refreshTokenRepository = refreshTokenRepository;
        this.authorizationCodeRepository = authorizationCodeRepository;
        this.userRepository = userRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.consentExpiryDurationDays = consentExpiryDurationDays;
        this.userConsentRepository = userConsentRepository;
        this.cronJobResponsible = cronJobResponsible;
        this.keyRollover = keyRollover;
    }

    @Scheduled(cron="${cron.token-cleaner-expression}")
    public void clean() {
        if (!this.cronJobResponsible) {
            return;
        }
        Date now = new Date();
        this.info(AccessToken.class, this.accessTokenRepository.deleteByExpiresInBefore(now).longValue());
        this.info(RefreshToken.class, this.refreshTokenRepository.deleteByExpiresInBefore(now).longValue());
        this.info(AuthorizationCode.class, this.authorizationCodeRepository.deleteByExpiresInBefore(now).longValue());
        this.info(AuthenticationRequest.class, this.authenticationRequestRepository.deleteByExpiresInBefore(now).longValue());
        List subs = this.authorizationCodeRepository.findSub().stream().map(AuthorizationCode::getSub).collect(Collectors.toList());
        this.info(User.class, this.userRepository.deleteBySubNotIn(subs).longValue());
        Date userConsentExpiryDate = Date.from(now.toInstant().minus(this.consentExpiryDurationDays, ChronoUnit.DAYS).atZone(ZoneId.systemDefault()).toInstant());
        this.info(UserConsent.class, this.userConsentRepository.deleteByLastAccessedBefore(userConsentExpiryDate).longValue());
        this.keyRollover.cleanUpSigningKeys();
        this.keyRollover.cleanUpSymmetricKeys();
    }

    private void info(Class clazz, long count) {
        LOG.info((Object)String.format("Deleted %s instances of %s", count, clazz));
    }
}

