/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenIntrospectionRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.PlainClientSecret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import java.io.IOException;
import java.time.Clock;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import oidc.eduid.AttributePseudonymisation;
import oidc.endpoints.SecureEndpoint;
import oidc.exceptions.UnauthorizedException;
import oidc.exceptions.UnknownClientException;
import oidc.log.MDCContext;
import oidc.model.AccessToken;
import oidc.model.OpenIDClient;
import oidc.model.User;
import oidc.repository.AccessTokenRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.secure.TokenGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IntrospectEndpoint
extends SecureEndpoint {
    private static final Log LOG = LogFactory.getLog(IntrospectEndpoint.class);
    private final AccessTokenRepository accessTokenRepository;
    private final OpenIDClientRepository openIDClientRepository;
    private final String issuer;
    private final TokenGenerator tokenGenerator;
    private final AttributePseudonymisation attributePseudonymisation;
    private final boolean enforceEduidResourceServerLinkedAccount;

    public IntrospectEndpoint(AccessTokenRepository accessTokenRepository, OpenIDClientRepository openIDClientRepository, TokenGenerator tokenGenerator, AttributePseudonymisation attributePseudonymisation, @Value(value="${sp.entity_id}") String issuer, @Value(value="${features.enforce-eduid-resource-server-linked-account}") boolean enforceEduidResourceServerLinkedAccount) {
        this.accessTokenRepository = accessTokenRepository;
        this.openIDClientRepository = openIDClientRepository;
        this.tokenGenerator = tokenGenerator;
        this.attributePseudonymisation = attributePseudonymisation;
        this.issuer = issuer;
        this.enforceEduidResourceServerLinkedAccount = enforceEduidResourceServerLinkedAccount;
    }

    @PostMapping(value={"oidc/introspect"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<Map<String, Object>> introspect(HttpServletRequest request) throws ParseException, IOException, java.text.ParseException {
        boolean isUserAccessToken;
        HTTPRequest httpRequest = ServletUtils.createHTTPRequest((HttpServletRequest)request);
        TokenIntrospectionRequest tokenIntrospectionRequest = TokenIntrospectionRequest.parse((HTTPRequest)httpRequest);
        ClientAuthentication clientAuthentication = tokenIntrospectionRequest.getClientAuthentication();
        String accessTokenValue = tokenIntrospectionRequest.getToken().getValue();
        if (!(clientAuthentication instanceof PlainClientSecret)) {
            LOG.warn((Object)"No authentication present");
            throw new UnauthorizedException("Invalid user / secret");
        }
        OpenIDClient resourceServer = (OpenIDClient)this.openIDClientRepository.findOptionalByClientId(clientAuthentication.getClientID().getValue()).orElseThrow(UnknownClientException::new);
        MDCContext.mdcContext((String[])new String[]{"action", "Introspect", "rp", resourceServer.getClientId(), "accessTokenValue", accessTokenValue});
        if (!this.secretsMatch((PlainClientSecret)clientAuthentication, resourceServer)) {
            LOG.warn((Object)("Secret does not match for RS " + resourceServer.getClientId()));
            throw new UnauthorizedException("Invalid user / secret");
        }
        if (!resourceServer.isResourceServer()) {
            LOG.warn((Object)("RS required for not configured for RP " + resourceServer.getClientId()));
            throw new UnauthorizedException("Requires ResourceServer");
        }
        Optional optionalSignedJWT = this.tokenGenerator.parseAndValidateSignedJWT(accessTokenValue);
        if (!optionalSignedJWT.isPresent()) {
            LOG.warn((Object)("Invalid access_token " + accessTokenValue));
            return ResponseEntity.ok(Collections.singletonMap("active", false));
        }
        SignedJWT signedJWT = (SignedJWT)optionalSignedJWT.get();
        String jwtId = signedJWT.getJWTClaimsSet().getJWTID();
        Optional optionalAccessToken = this.accessTokenRepository.findByJwtId(jwtId);
        if (!optionalAccessToken.isPresent()) {
            LOG.warn((Object)("No access_token found " + accessTokenValue));
            return ResponseEntity.ok(Collections.singletonMap("active", false));
        }
        AccessToken accessToken = (AccessToken)optionalAccessToken.get();
        if (accessToken.isExpired(Clock.systemDefaultZone())) {
            LOG.warn((Object)("Access token is expired " + accessTokenValue));
            return ResponseEntity.ok(Collections.singletonMap("active", false));
        }
        List scopes = accessToken.getScopes();
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        boolean bl = isUserAccessToken = !accessToken.isClientCredentials();
        if (isUserAccessToken) {
            OpenIDClient openIDClient = (OpenIDClient)this.openIDClientRepository.findOptionalByClientId(accessToken.getClientId()).orElseThrow(UnknownClientException::new);
            if (!openIDClient.getClientId().equals(resourceServer.getClientId()) && !openIDClient.getAllowedResourceServers().contains(resourceServer.getClientId())) {
                throw new UnauthorizedException(String.format("RP %s is not allowed to use the API of resource server %s. Allowed resource servers are %s", accessToken.getClientId(), resourceServer.getClientId(), openIDClient.getAllowedResourceServers()));
            }
            User user = this.tokenGenerator.decryptAccessTokenWithEmbeddedUserInfo(signedJWT);
            result.put("updated_at", user.getUpdatedAt());
            if (resourceServer.isIncludeUnspecifiedNameID()) {
                result.put("unspecified_id", user.getUnspecifiedNameId());
            }
            result.put("authenticating_authority", user.getAuthenticatingAuthority());
            result.put("sub", user.getSub());
            result.putAll(user.getAttributes());
            boolean validPseudonymisation = this.validPseudonymisation(result, resourceServer, openIDClient);
            if (!validPseudonymisation && this.enforceEduidResourceServerLinkedAccount) {
                LOG.warn((Object)String.format("Pseudonymisation failed. No eduperson_principal_name for RS %s", resourceServer.getClientId()));
                return ResponseEntity.ok(Collections.singletonMap("active", false));
            }
        }
        result.put("active", true);
        result.put("scope", String.join((CharSequence)" ", scopes));
        result.put("client_id", accessToken.getClientId());
        result.put("exp", accessToken.getExpiresIn().getTime() / 1000L);
        result.put("sub", accessToken.getSub());
        result.put("iss", this.issuer);
        result.put("token_type", "Bearer");
        LOG.debug((Object)String.format("Returning introspect active %s for RS %s", true, resourceServer.getClientId()));
        return ResponseEntity.ok(result);
    }

    private boolean validPseudonymisation(Map<String, Object> userAttributes, OpenIDClient resourceServer, OpenIDClient openIDClient) {
        String eduId = (String)userAttributes.get("eduid");
        Optional pseudonymiseResult = this.attributePseudonymisation.pseudonymise(resourceServer, openIDClient, eduId);
        if (pseudonymiseResult.isPresent() && !((Map)pseudonymiseResult.get()).containsKey("eduperson_principal_name")) {
            userAttributes.put("eduid", ((Map)pseudonymiseResult.get()).get("eduid"));
            return false;
        }
        userAttributes.putAll(pseudonymiseResult.orElseGet(Collections::emptyMap));
        return true;
    }
}

