/*
 * Decompiled with CFR 0.152.
 */
package oidc.web;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oidc.endpoints.AuthorizationEndpoint;
import oidc.exceptions.UnknownClientException;
import oidc.model.OpenIDClient;
import oidc.repository.OpenIDClientRepository;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.CollectionUtils;

public class RedirectAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private final OpenIDClientRepository openIDClientRepository;
    private RequestCache requestCache = new HttpSessionRequestCache();

    public RedirectAuthenticationFailureHandler(OpenIDClientRepository openIDClientRepository) {
        this.openIDClientRepository = openIDClientRepository;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        HttpSession session = request.getSession(false);
        SavedRequest savedRequest = null;
        if (session != null) {
            savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        }
        if (savedRequest == null) {
            savedRequest = this.requestCache.getRequest(request, response);
        }
        if (savedRequest != null) {
            Map parameterMap = savedRequest.getParameterMap();
            Map<String, List> parameters = parameterMap.keySet().stream().collect(Collectors.toMap(key -> key, key -> Arrays.asList((Object[])parameterMap.get(key))));
            List redirectUris = parameters.get("redirect_uri");
            URI redirectURI = CollectionUtils.isEmpty((Collection)redirectUris) ? null : new URI((String)redirectUris.get(0));
            List clientIds = parameters.get("client_id");
            String clientId = CollectionUtils.isEmpty((Collection)clientIds) ? null : (String)clientIds.get(0);
            OpenIDClient openIDClient = (OpenIDClient)this.openIDClientRepository.findOptionalByClientId(clientId).orElseThrow(UnknownClientException::new);
            AuthorizationEndpoint.validateRedirectionURI((URI)redirectURI, (OpenIDClient)openIDClient);
            request.setAttribute("REDIRECT_URI_VALID", (Object)true);
        }
        if (exception instanceof Saml2AuthenticationException) {
            throw new Saml2AuthenticationException(new Saml2Error("internal_validation_error", "The requesting service has indicated that the authenticated user is required to have validated attributes. Your institution has not provided this."), "The requesting service has indicated that the authenticated user is required to have validated attributes. Your institution has not provided this.", (Throwable)exception);
        }
        throw exception;
    }
}

