/*
 * Decompiled with CFR 0.152.
 */
package oidc.model;

import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.Assert;

@Document(collection="symmetric_keys")
public class SymmetricKey {
    @Id
    private String id;
    private String keyId;
    private String aead;
    private Date created;

    public SymmetricKey(String keyId, String aead, Date created) {
        Assert.notNull((Object)keyId, (String)"KeyID must not be null");
        Assert.notNull((Object)aead, (String)"Aead must not be null");
        Assert.isTrue((boolean)Base64.isBase64((String)aead), (String)"Aead must be base64 encoded");
        this.keyId = keyId;
        this.aead = aead;
        this.created = created;
    }

    public String getId() {
        return this.id;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getAead() {
        return this.aead;
    }

    public Date getCreated() {
        return this.created;
    }
}

