/*
 * Decompiled with CFR 0.152.
 */
package oidc.model;

import java.net.URI;

public class ProvidedRedirectURI {
    private final String redirectURI;
    private final URI me;

    public ProvidedRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        this.me = URI.create(redirectURI);
    }

    public boolean equalsIgnorePort(String uri) {
        URI that = URI.create(uri);
        return that.getScheme().equals(this.me.getScheme()) && that.getHost().equals(this.me.getHost()) && that.getPath().equals(this.me.getPath());
    }

    public boolean literalCheckRequired() {
        String host = this.me.getHost();
        return !"127.0.0.1".equals(host) && !"localhost".equals(host);
    }

    public String toString() {
        return this.redirectURI;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public URI getMe() {
        return this.me;
    }
}

