/*
 * Decompiled with CFR 0.152.
 */
package oidc.saml;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oidc.model.SamlAuthenticationRequest;
import oidc.repository.SamlAuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2RedirectAuthenticationRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;

public class MongoSaml2AuthenticationRequestRepository
implements Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> {
    private final SamlAuthenticationRequestRepository samlAuthenticationRequestRepository;
    private final RelyingPartyRegistration relyingPartyRegistration;

    public MongoSaml2AuthenticationRequestRepository(SamlAuthenticationRequestRepository samlAuthenticationRequestRepository, RelyingPartyRegistration relyingPartyRegistration) {
        this.samlAuthenticationRequestRepository = samlAuthenticationRequestRepository;
        this.relyingPartyRegistration = relyingPartyRegistration;
    }

    public AbstractSaml2AuthenticationRequest loadAuthenticationRequest(HttpServletRequest request) {
        SamlAuthenticationRequest samlAuthenticationRequest = this.doLoadAuthenticationRequest(request);
        if (samlAuthenticationRequest == null) {
            return null;
        }
        return this.buildSaml2RedirectAuthenticationRequest(samlAuthenticationRequest);
    }

    public void saveAuthenticationRequest(AbstractSaml2AuthenticationRequest authenticationRequest, HttpServletRequest request, HttpServletResponse response) {
        Saml2RedirectAuthenticationRequest redirectAuthenticationRequest = (Saml2RedirectAuthenticationRequest)authenticationRequest;
        SamlAuthenticationRequest samlAuthenticationRequest = new SamlAuthenticationRequest(request.getSession(true).getId(), redirectAuthenticationRequest.getSamlRequest(), redirectAuthenticationRequest.getSigAlg(), redirectAuthenticationRequest.getSignature(), redirectAuthenticationRequest.getRelayState(), redirectAuthenticationRequest.getAuthenticationRequestUri());
        this.samlAuthenticationRequestRepository.save((Object)samlAuthenticationRequest);
    }

    public AbstractSaml2AuthenticationRequest removeAuthenticationRequest(HttpServletRequest request, HttpServletResponse response) {
        SamlAuthenticationRequest samlAuthenticationRequest = this.doLoadAuthenticationRequest(request);
        if (samlAuthenticationRequest == null) {
            return null;
        }
        this.samlAuthenticationRequestRepository.delete((Object)samlAuthenticationRequest);
        return this.buildSaml2RedirectAuthenticationRequest(samlAuthenticationRequest);
    }

    private SamlAuthenticationRequest doLoadAuthenticationRequest(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return this.samlAuthenticationRequestRepository.findById((Object)session.getId()).orElse(null);
    }

    private Saml2RedirectAuthenticationRequest buildSaml2RedirectAuthenticationRequest(SamlAuthenticationRequest samlAuthenticationRequest) {
        return ((Saml2RedirectAuthenticationRequest.Builder)((Saml2RedirectAuthenticationRequest.Builder)Saml2RedirectAuthenticationRequest.withRelyingPartyRegistration((RelyingPartyRegistration)this.relyingPartyRegistration).signature(samlAuthenticationRequest.getSignature()).sigAlg(samlAuthenticationRequest.getSigAlg()).relayState(samlAuthenticationRequest.getRelayState())).samlRequest(samlAuthenticationRequest.getSamlRequest())).build();
    }
}

