/*
 * Decompiled with CFR 0.152.
 */
package oidc.model;

import java.net.URI;
import java.util.Objects;
import org.springframework.util.StringUtils;

public class ProvidedRedirectURI {
    private final String redirectURI;
    private final URI me;

    public ProvidedRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        this.me = URI.create(redirectURI);
    }

    public boolean equalsWithLiteralCheckRequired(String uri) {
        boolean equals;
        URI that = URI.create(uri);
        if (StringUtils.hasText((String)that.getFragment())) {
            return false;
        }
        boolean bl = equals = that.getScheme().equals(this.me.getScheme()) && that.getHost().equals(this.me.getHost()) && that.getPath().equals(this.me.getPath()) && Objects.equals(that.getQuery(), this.me.getQuery());
        return this.literalCheckRequired() ? equals && that.getPort() == this.me.getPort() : equals;
    }

    private boolean literalCheckRequired() {
        String host = this.me.getHost();
        return !"127.0.0.1".equals(host) && !"localhost".equals(host);
    }

    public String toString() {
        return this.redirectURI;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public URI getMe() {
        return this.me;
    }
}

