/*
 * Decompiled with CFR 0.152.
 */
package oidc.api;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import oidc.api.APIVersion;
import oidc.crypto.KeyGenerator;
import oidc.model.AccessToken;
import oidc.model.OpenIDClient;
import oidc.model.RefreshToken;
import oidc.model.Scope;
import oidc.model.TokenRepresentation;
import oidc.model.TokenType;
import oidc.repository.AccessTokenRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.repository.RefreshTokenRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TokenController {
    private static final Log LOG = LogFactory.getLog(TokenController.class);
    private final AccessTokenRepository accessTokenRepository;
    private final RefreshTokenRepository refreshTokenRepository;
    private final OpenIDClientRepository openIDClientRepository;
    private final String salt;

    public TokenController(AccessTokenRepository accessTokenRepository, RefreshTokenRepository refreshTokenRepository, OpenIDClientRepository openIDClientRepository, @Value(value="${access_token_one_way_hash_salt}") String salt) {
        this.accessTokenRepository = accessTokenRepository;
        this.refreshTokenRepository = refreshTokenRepository;
        this.openIDClientRepository = openIDClientRepository;
        this.salt = salt;
    }

    @GetMapping(value={"tokens"})
    @PreAuthorize(value="hasRole('ROLE_api_tokens')")
    public List<Map<String, Object>> tokens(Authentication authentication, @RequestParam(value="unspecifiedID") String unspecifiedId) throws UnsupportedEncodingException {
        return this.doTokens(authentication, unspecifiedId, APIVersion.V1);
    }

    @GetMapping(value={"v2/tokens"})
    @PreAuthorize(value="hasRole('ROLE_api_tokens')")
    public List<Map<String, Object>> tokensV2(Authentication authentication, @RequestParam(value="unspecifiedID") String unspecifiedId) throws UnsupportedEncodingException {
        return this.doTokens(authentication, unspecifiedId, APIVersion.V2);
    }

    private List<Map<String, Object>> doTokens(Authentication authentication, String unspecifiedId, APIVersion apiVersion) throws UnsupportedEncodingException {
        String name = authentication.getName();
        unspecifiedId = URLDecoder.decode(unspecifiedId, Charset.defaultCharset().name());
        LOG.debug((Object)String.format("Starting tokens GET for %s with unspecified %s", name, unspecifiedId));
        String unspecifiedUrnHash = KeyGenerator.oneWayHash((String)unspecifiedId, (String)this.salt);
        List accessTokens = this.accessTokenRepository.findByUnspecifiedUrnHash(unspecifiedUrnHash);
        List refreshTokens = this.refreshTokenRepository.findByUnspecifiedUrnHash(unspecifiedUrnHash);
        accessTokens.addAll(refreshTokens);
        List<Map<String, Object>> result = accessTokens.stream().map(token -> this.convertToken(token, apiVersion)).filter(map -> map.containsKey("clientName")).filter(map -> APIVersion.V1.equals((Object)apiVersion) || !((Collection)map.get("audiences")).isEmpty()).collect(Collectors.toList());
        LOG.debug((Object)String.format("Returning tokens for %s with unspecified %s: %s", name, unspecifiedId, result));
        return result;
    }

    @PutMapping(value={"tokens", "v2/tokens"})
    @PreAuthorize(value="hasRole('ROLE_api_tokens')")
    public ResponseEntity<Void> deleteTokens(Authentication authentication, @RequestBody List<TokenRepresentation> tokenIdentifiers) {
        String name = authentication.getName();
        LOG.debug((Object)String.format("Deleting tokens for %s with token(s) %s", name, tokenIdentifiers));
        tokenIdentifiers.stream().forEach(tokenRepresentation -> (tokenRepresentation.getType().equals((Object)TokenType.ACCESS) ? this.accessTokenRepository : this.refreshTokenRepository).deleteById((Object)tokenRepresentation.getId()));
        return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
    }

    private Map<String, Object> convertToken(AccessToken token, APIVersion version) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", token.getId());
        Optional optionalClient = this.openIDClientRepository.findOptionalByClientId(token.getClientId());
        if (!optionalClient.isPresent()) {
            return result;
        }
        OpenIDClient openIDClient = (OpenIDClient)optionalClient.get();
        result.put("clientId", openIDClient.getClientId());
        result.put("clientName", openIDClient.getName());
        result.put("createdAt", token.getCreatedAt());
        result.put("expiresIn", token.getExpiresIn());
        result.put("type", token instanceof RefreshToken ? TokenType.REFRESH : TokenType.ACCESS);
        List resourceServers = openIDClient.getAllowedResourceServers().stream().map(rs -> this.openIDClientRepository.findOptionalByClientId(rs)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (version.equals((Object)APIVersion.V1)) {
            result.put("audiences", resourceServers.stream().map(OpenIDClient::getName).collect(Collectors.toList()));
            Map allScopes = this.getAllScopes(resourceServers);
            List scopes = token.getScopes().stream().filter(name -> !name.equalsIgnoreCase("openid")).map(allScopes::get).filter(Objects::nonNull).collect(Collectors.toList());
            result.put("scopes", scopes);
        } else if (version.equals((Object)APIVersion.V2)) {
            result.put("audiences", this.resourceServersObjects(token, resourceServers));
        }
        return result;
    }

    private Map<String, Scope> getAllScopes(List<OpenIDClient> resourceServers) {
        return resourceServers.stream().map(OpenIDClient::getScopes).flatMap(Collection::stream).filter(this.distinctByKey(Scope::getName)).collect(Collectors.toMap(Scope::getName, s -> s));
    }

    private List<Map<String, Object>> resourceServersObjects(AccessToken token, List<OpenIDClient> resourceServers) {
        return resourceServers.stream().map(rs -> Map.of("name:en", this.safeNotNotValue(rs.getName()), "name:nl", this.safeNotNotValue(rs.getNameNl()), "description:en", this.safeNotNotValue(rs.getDescription()), "description:nl", this.safeNotNotValue(rs.getDescriptionNl()), "OrganizationName:en:", this.safeNotNotValue(rs.getOrganisationName()), "OrganizationName:nl:", this.safeNotNotValue(rs.getOrganisationNameNl()), "scopes", rs.getScopes().stream().filter(scope -> token.getScopes().contains(scope.getName()) && !scope.getName().equalsIgnoreCase("openid")).collect(Collectors.toList()))).filter(map -> !((Collection)map.get("scopes")).isEmpty()).collect(Collectors.toList());
    }

    private String safeNotNotValue(String value) {
        return StringUtils.hasText((String)value) ? value : "";
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }
}

