/*
 * Decompiled with CFR 0.152.
 */
package oidc.web;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.oauth2.sdk.ParseException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oidc.exceptions.BaseException;
import oidc.exceptions.CodeVerifierMissingException;
import oidc.exceptions.CookiesNotSupportedException;
import oidc.exceptions.RedirectMismatchException;
import oidc.exceptions.TokenAlreadyUsedException;
import oidc.exceptions.UnauthorizedException;
import oidc.exceptions.UnknownClientException;
import oidc.exceptions.UnsupportedPromptValueException;
import oidc.saml.ContextSaml2AuthenticationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
public class ErrorController
implements org.springframework.boot.web.servlet.error.ErrorController {
    private static final Log LOG = LogFactory.getLog(ErrorController.class);
    private final DefaultErrorAttributes errorAttributes;
    private RequestCache requestCache = new HttpSessionRequestCache();
    private List<Class> exceptionsToExclude = List.of(RedirectMismatchException.class, UnauthorizedException.class, CodeVerifierMissingException.class, UnsupportedPromptValueException.class, TokenAlreadyUsedException.class, UnknownClientException.class);

    public ErrorController() {
        this.errorAttributes = new DefaultErrorAttributes();
    }

    @RequestMapping(value={"${server.error.path:${error.path:/error}}"})
    public Object error(HttpServletRequest request) {
        HttpStatus statusCode;
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Map result = this.errorAttributes.getErrorAttributes((WebRequest)webRequest, ErrorAttributeOptions.defaults());
        Throwable error = this.errorAttributes.getError((WebRequest)webRequest);
        if (error instanceof CookiesNotSupportedException) {
            return new ModelAndView("no_session_found", HttpStatus.OK);
        }
        if (error != null && error.getCause() != null) {
            error = error.getCause();
        }
        boolean status = result.containsKey("status") && !result.get("status").equals(999) && !result.get("status").equals(500);
        HttpStatus httpStatus = statusCode = status ? HttpStatus.resolve((int)((Integer)result.get("status"))) : HttpStatus.BAD_REQUEST;
        if (error != null) {
            String message = error.getMessage();
            if (!"AccessToken not found".equals(message)) {
                if (this.exceptionsToExclude.contains(error.getClass())) {
                    LOG.error((Object)("Error has occurred: " + error));
                } else {
                    LOG.error((Object)"Error has occurred", error);
                }
            }
            result.put("error_description", message);
            result.put("message", message);
            ResponseStatus annotation = (ResponseStatus)AnnotationUtils.getAnnotation(error.getClass(), ResponseStatus.class);
            HttpStatus httpStatus2 = statusCode = annotation != null ? annotation.value() : statusCode;
            if (error instanceof JOSEException || error instanceof EmptyResultDataAccessException && result.getOrDefault("path", "/oidc/token").toString().contains("token")) {
                return new ResponseEntity(Collections.singletonMap("error", "invalid_grant"), HttpStatus.BAD_REQUEST);
            }
        }
        result.put("error", this.errorCode(error));
        result.put("status", statusCode.value());
        Object redirectUriValid = request.getAttribute("REDIRECT_URI_VALID");
        String redirectUri = request.getParameter("redirect_uri");
        Map parameterMap = request.getParameterMap();
        SavedRequest savedRequest = this.requestCache.getRequest(request, null);
        boolean redirect = false;
        if (error instanceof ContextSaml2AuthenticationException) {
            ContextSaml2AuthenticationException ctxE = (ContextSaml2AuthenticationException)error;
            String originalRequestUrl = ctxE.getAuthenticationRequest().getOriginalRequestUrl();
            UriComponents uriComponent = UriComponentsBuilder.fromUriString((String)originalRequestUrl).build();
            redirectUri = (String)uriComponent.getQueryParams().getFirst((Object)"redirect_uri");
            redirect = true;
        } else if (savedRequest == null) {
            LOG.warn((Object)"No saved request found. Check the cookie flow");
        }
        if (savedRequest instanceof DefaultSavedRequest) {
            parameterMap = savedRequest.getParameterMap();
            String requestURI = ((DefaultSavedRequest)savedRequest).getRequestURI();
            String[] redirectUris = (String[])parameterMap.get("redirect_uri");
            if (requestURI != null && requestURI.contains("authorize") && redirectUris != null) {
                redirectUri = redirectUris[0];
                redirect = true;
            }
        }
        if (redirectUriValid != null && ((Boolean)redirectUriValid).booleanValue() && (statusCode.is3xxRedirection() || redirect || StringUtils.hasText((String)redirectUri))) {
            return this.redirectErrorResponse(parameterMap, result, error, redirectUri);
        }
        return new ResponseEntity((Object)result, statusCode);
    }

    private String errorCode(Throwable error) {
        if (error == null) {
            return "unknown_exception";
        }
        if (error instanceof BaseException) {
            return ((BaseException)error).getErrorCode();
        }
        if (error instanceof ParseException) {
            return "invalid_request";
        }
        if (error instanceof Saml2AuthenticationException) {
            return "access_denied";
        }
        return error.getMessage();
    }

    private String errorMessage(Throwable error) throws UnsupportedEncodingException {
        String errorMsg = error != null ? error.getMessage() : "Unknown exception occurred";
        return URLEncoder.encode(errorMsg.replaceAll("\"", ""), "UTF-8");
    }

    private Object redirectErrorResponse(Map<String, String[]> parameterMap, Map<String, Object> result, Throwable error, String redirectUri) throws UnsupportedEncodingException {
        String url = URLDecoder.decode(redirectUri, "UTF-8");
        String responseType = this.defaultValue(parameterMap, "response_type", "code");
        String responseMode = this.defaultValue(parameterMap, "response_mode", "code".equals(responseType) ? "query" : "fragment");
        String errorCode = this.errorCode(error);
        String errorMessage = this.errorMessage(error);
        String state = this.defaultValue(parameterMap, "state", null);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)url);
        switch (responseMode) {
            case "query": {
                uriComponentsBuilder.queryParam("error", new Object[]{errorCode}).queryParam("error_description", new Object[]{errorMessage});
                if (!StringUtils.hasText((String)state)) break;
                uriComponentsBuilder.queryParam("state", new Object[]{state});
                break;
            }
            case "fragment": {
                String fragment = String.format("error=%s&error_description=%s", errorCode, errorMessage);
                if (StringUtils.hasText((String)state)) {
                    fragment = fragment.concat(String.format("&state=%s", state));
                }
                uriComponentsBuilder.fragment(fragment);
                break;
            }
            case "form_post": {
                HashMap<String, String> body = new HashMap<String, String>();
                body.put("redirect_uri", url);
                body.put("error", errorCode);
                body.put("error_description", errorMessage);
                if (StringUtils.hasText((String)state)) {
                    body.put("state", state);
                }
                LOG.debug((Object)("Post form to " + url));
                return new ModelAndView("form_post", body);
            }
        }
        URI uri = uriComponentsBuilder.build().toUri();
        LOG.debug((Object)("Redirect to " + uri));
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uri);
        return new ResponseEntity(result, (MultiValueMap)headers, HttpStatus.FOUND);
    }

    private String defaultValue(Map<String, String[]> parameterMap, String key, String defaultValue) {
        String[] value = parameterMap.get(key);
        return value != null && value.length > 0 ? value[0] : defaultValue;
    }
}

