/*
 * Decompiled with CFR 0.152.
 */
package oidc.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="users")
public class User
implements Serializable {
    @Id
    private String id;
    private String sub;
    private String unspecifiedNameId;
    private String authenticatingAuthority;
    private String clientId;
    private long updatedAt = System.currentTimeMillis() / 1000L;
    private Map<String, Object> attributes = new HashMap();
    private List<String> acrClaims = new ArrayList();

    public User(String sub, String unspecifiedNameId, String authenticatingAuthority, String clientId, Map<String, Object> attributes, List<String> acrClaims) {
        this.sub = sub;
        this.unspecifiedNameId = unspecifiedNameId;
        this.authenticatingAuthority = authenticatingAuthority;
        this.clientId = clientId;
        this.attributes = attributes;
        this.acrClaims = acrClaims;
    }

    public User() {
    }

    public String getId() {
        return this.id;
    }

    public String getSub() {
        return this.sub;
    }

    public String getUnspecifiedNameId() {
        return this.unspecifiedNameId;
    }

    public String getAuthenticatingAuthority() {
        return this.authenticatingAuthority;
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public List<String> getAcrClaims() {
        return this.acrClaims;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$sub = this.getSub();
        String other$sub = other.getSub();
        if (this$sub == null ? other$sub != null : !this$sub.equals(other$sub)) {
            return false;
        }
        String this$unspecifiedNameId = this.getUnspecifiedNameId();
        String other$unspecifiedNameId = other.getUnspecifiedNameId();
        if (this$unspecifiedNameId == null ? other$unspecifiedNameId != null : !this$unspecifiedNameId.equals(other$unspecifiedNameId)) {
            return false;
        }
        String this$authenticatingAuthority = this.getAuthenticatingAuthority();
        String other$authenticatingAuthority = other.getAuthenticatingAuthority();
        if (this$authenticatingAuthority == null ? other$authenticatingAuthority != null : !this$authenticatingAuthority.equals(other$authenticatingAuthority)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        Map this$attributes = this.getAttributes();
        Map other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        List this$acrClaims = this.getAcrClaims();
        List other$acrClaims = other.getAcrClaims();
        return !(this$acrClaims == null ? other$acrClaims != null : !((Object)this$acrClaims).equals(other$acrClaims));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sub = this.getSub();
        result = result * 59 + ($sub == null ? 43 : $sub.hashCode());
        String $unspecifiedNameId = this.getUnspecifiedNameId();
        result = result * 59 + ($unspecifiedNameId == null ? 43 : $unspecifiedNameId.hashCode());
        String $authenticatingAuthority = this.getAuthenticatingAuthority();
        result = result * 59 + ($authenticatingAuthority == null ? 43 : $authenticatingAuthority.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        Map $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        List $acrClaims = this.getAcrClaims();
        result = result * 59 + ($acrClaims == null ? 43 : ((Object)$acrClaims).hashCode());
        return result;
    }

    public String toString() {
        return "User(sub=" + this.getSub() + ", unspecifiedNameId=" + this.getUnspecifiedNameId() + ", authenticatingAuthority=" + this.getAuthenticatingAuthority() + ", clientId=" + this.getClientId() + ", attributes=" + String.valueOf(this.getAttributes()) + ", acrClaims=" + String.valueOf(this.getAcrClaims()) + ")";
    }

    public void setId(String id) {
        this.id = id;
    }
}

