/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.device.DeviceAuthorizationRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import oidc.endpoints.AuthorizationEndpoint;
import oidc.endpoints.OidcEndpoint;
import oidc.exceptions.InvalidGrantException;
import oidc.exceptions.UnknownClientException;
import oidc.model.DeviceAuthorization;
import oidc.model.DeviceAuthorizationStatus;
import oidc.model.OpenIDClient;
import oidc.model.User;
import oidc.qr.QRGenerator;
import oidc.repository.DeviceAuthorizationRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.user.OidcSamlAuthentication;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@RestController
@ConditionalOnExpression(value="${features.oidcng_device_flow:false}")
public class DeviceAuthorizationEndpoint
implements OidcEndpoint {
    private static final Log LOG = LogFactory.getLog(DeviceAuthorizationEndpoint.class);
    private static final char[] USER_CODE_CODEX = "BCDFGHJKLMNPQRSTVWXZ".toCharArray();
    private static final int RATE_LIMIT = 3;
    private static final Random random = new SecureRandom();
    private final DeviceAuthorizationRepository deviceAuthorizationRepository;
    private final OpenIDClientRepository openIDClientRepository;
    private final String verificationUrl;
    private final String environment;

    public DeviceAuthorizationEndpoint(DeviceAuthorizationRepository deviceAuthorizationRepository, OpenIDClientRepository openIDClientRepository, @Value(value="${device_verification_url}") String verificationUrl, @Value(value="${environment}") String environment) {
        this.deviceAuthorizationRepository = deviceAuthorizationRepository;
        this.openIDClientRepository = openIDClientRepository;
        this.verificationUrl = verificationUrl;
        this.environment = environment;
    }

    @PostMapping(value={"oidc/device_authorization"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<Map<String, Object>> deviceAuthorization(HttpServletRequest request) throws IOException, ParseException {
        HTTPRequest httpRequest = JakartaServletUtils.createHTTPRequest((HttpServletRequest)request);
        DeviceAuthorizationRequest deviceAuthorizationRequest = DeviceAuthorizationRequest.parse((HTTPRequest)httpRequest);
        String clientId = deviceAuthorizationRequest.getClientID().getValue();
        OpenIDClient client = (OpenIDClient)this.openIDClientRepository.findOptionalByClientId(clientId).orElseThrow(() -> new UnknownClientException(clientId));
        if (!client.getGrants().contains(GrantType.DEVICE_CODE.getValue())) {
            throw new InvalidGrantException(String.format("Missing grant: %s for clientId: %s", GrantType.DEVICE_CODE.getValue(), clientId));
        }
        List scopes = AuthorizationEndpoint.validateScopes((OpenIDClientRepository)this.openIDClientRepository, (Scope)deviceAuthorizationRequest.getScope(), (OpenIDClient)client);
        LOG.debug((Object)String.format("Device Authorization flow for clientId: %s, scopes: %s", clientId, scopes));
        String deviceCode = UUID.randomUUID().toString();
        String userCode = this.generateUserCode();
        DeviceAuthorization deviceAuthorization = new DeviceAuthorization(null, clientId, deviceCode, userCode.replaceAll("-", ""), scopes, UUID.randomUUID().toString(), this.getCustomParam(deviceAuthorizationRequest, "prompt"), this.getCustomParam(deviceAuthorizationRequest, "acr_values"), this.getCustomParam(deviceAuthorizationRequest, "login_hint"), DeviceAuthorizationStatus.authorization_pending, null, null, Instant.now().plus(15L, ChronoUnit.MINUTES));
        this.deviceAuthorizationRepository.save((Object)deviceAuthorization);
        Map<String, Integer> results = Map.of("device_code", deviceCode, "user_code", userCode, "verification_uri", this.verificationUrl, "verification_uri_complete", String.format("%s?user_code=%s", this.verificationUrl, userCode), "qr_code", QRGenerator.qrCode((String)this.verificationUrl).getImage(), "expires_in", 900, "interval", 1);
        return ResponseEntity.ok(results);
    }

    @GetMapping(value={"oidc/verify"})
    public ModelAndView verification(@RequestParam(value="user_code", required=false) String userCode, @RequestParam(value="error", required=false, defaultValue="false") String error, HttpServletRequest request) {
        HashMap<String, Comparable<Boolean>> model = new HashMap<String, Comparable<Boolean>>();
        if (StringUtils.hasText((String)userCode)) {
            this.findByUserCode(userCode).flatMap(deviceAuthorization -> this.openIDClientRepository.findOptionalByClientId(deviceAuthorization.getClientId())).ifPresent(openIDClient -> {
                model.put("client", (Comparable<Boolean>)openIDClient);
                model.put("userCode", (Comparable<Boolean>)((Object)userCode));
                model.put("completeURI", (Comparable<Boolean>)true);
            });
        }
        model.putIfAbsent("completeURI", Boolean.valueOf(false));
        this.addStandardModelAttributes(model);
        boolean hasError = Boolean.parseBoolean(error);
        if (hasError) {
            HttpSession session = request.getSession(true);
            Integer attempts = (Integer)session.getAttribute("attempts");
            attempts = attempts == null ? 1 : attempts + 1;
            session.setAttribute("attempts", (Object)attempts);
            if (attempts >= 3) {
                model.put("rateLimitExceeded", Boolean.valueOf(true));
            } else {
                model.put("attemptsLeft", Integer.valueOf(3 - attempts));
            }
        }
        model.put("error", Boolean.valueOf(hasError));
        model.putIfAbsent("rateLimitExceeded", Boolean.valueOf(false));
        return new ModelAndView("verify", model);
    }

    @PostMapping(value={"oidc/verify"})
    public ModelAndView postVerify(@RequestParam Map<String, String> body, HttpServletRequest request) {
        String userCode = body.getOrDefault("userCode", body.get("userCodeComplete"));
        ModelAndView modelAndView = this.findByUserCode(userCode).filter(deviceAuthorization -> deviceAuthorization.getStatus().equals((Object)DeviceAuthorizationStatus.authorization_pending)).map(deviceAuthorization -> {
            this.logout(request);
            return new ModelAndView((View)new RedirectView(this.deviceAuthorizeURL(deviceAuthorization), true));
        }).orElseGet(() -> this.verification(null, "true", request));
        return modelAndView;
    }

    @GetMapping(value={"/oidc/device_authorize"})
    public ModelAndView deviceAuthorize(@RequestParam(value="state") String state, @RequestParam(value="user_code") String userCode, Authentication authentication) {
        LOG.debug((Object)String.format("/oidc/device_authorize %s %s", authentication.getDetails(), userCode));
        HashMap model = new HashMap();
        Optional optionalDeviceAuthorization = this.findByUserCode(userCode);
        AtomicBoolean stateMatches = new AtomicBoolean(false);
        optionalDeviceAuthorization.ifPresent(deviceAuthorization -> {
            stateMatches.set(state.equals(deviceAuthorization.getState()));
            this.openIDClientRepository.findOptionalByClientId(deviceAuthorization.getClientId()).ifPresent(openIDClient -> model.put("client", openIDClient));
            OidcSamlAuthentication oidcSamlAuthentication = (OidcSamlAuthentication)authentication;
            User user = oidcSamlAuthentication.getUser();
            model.put("user", user);
            deviceAuthorization.setStatus(DeviceAuthorizationStatus.success);
            deviceAuthorization.setUserSub(user.getSub());
            this.deviceAuthorizationRepository.save(deviceAuthorization);
        });
        this.addStandardModelAttributes(model);
        return new ModelAndView(optionalDeviceAuthorization.isPresent() && stateMatches.get() ? "device_continue" : "device_error", model);
    }

    protected String generateUserCode() {
        byte[] verifierBytes = new byte[8];
        random.nextBytes(verifierBytes);
        char[] chars = new char[verifierBytes.length];
        for (int i = 0; i < verifierBytes.length; ++i) {
            chars[i] = USER_CODE_CODEX[random.nextInt(USER_CODE_CODEX.length)];
        }
        String userCode = new String(chars);
        return userCode.substring(0, 4) + "-" + userCode.substring(4);
    }

    private Optional<DeviceAuthorization> findByUserCode(String userCode) {
        userCode = userCode.toUpperCase().replaceAll("-", "");
        return this.deviceAuthorizationRepository.findByUserCode(userCode);
    }

    private void addStandardModelAttributes(Map<String, Object> model) {
        Locale locale = LocaleContextHolder.getLocale();
        model.put("lang", locale.getLanguage());
        model.put("environment", this.environment);
    }

    private String getCustomParam(DeviceAuthorizationRequest deviceAuthorizationRequest, String key) {
        List values = (List)deviceAuthorizationRequest.getCustomParameters().get(key);
        return CollectionUtils.isEmpty((Collection)values) ? null : (String)values.get(0);
    }

    private String deviceAuthorizeURL(DeviceAuthorization deviceAuthorization) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_id", deviceAuthorization.getClientId());
        parameters.put("user_code", deviceAuthorization.getUserCode());
        parameters.put("prompt", deviceAuthorization.getPrompt());
        parameters.put("acr_values", deviceAuthorization.getAcrValues());
        parameters.put("login_hint", deviceAuthorization.getLoginHint());
        parameters.put("state", deviceAuthorization.getState());
        String queryParams = parameters.entrySet().stream().filter(entry -> StringUtils.hasText((String)((String)entry.getValue()))).map(entry -> (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), Charset.defaultCharset())).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
        return String.format("/oidc/device_authorize?%s", queryParams);
    }
}

