/*
 * Decompiled with CFR 0.152.
 */
package oidc.model;

import java.util.Date;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.Assert;

@Document(collection="signing_keys")
public class SigningKey {
    @Id
    private String id;
    private final String keyId;
    private final String symmetricKeyId;
    private final String jwk;
    private final Date created;

    public SigningKey(String keyId, String symmetricKeyId, String jwk, Date created) {
        Assert.notNull((Object)keyId, (String)"KeyID must not be null");
        Assert.notNull((Object)symmetricKeyId, (String)"SymmetricKeyId must not be null");
        Assert.notNull((Object)jwk, (String)"Jwk must not be null");
        Assert.isTrue((boolean)Base64.isBase64((String)jwk), (String)"Jwk must be base64 encoded");
        this.keyId = keyId;
        this.symmetricKeyId = symmetricKeyId;
        this.jwk = jwk;
        this.created = created;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getKeyId() {
        return this.keyId;
    }

    @Generated
    public String getSymmetricKeyId() {
        return this.symmetricKeyId;
    }

    @Generated
    public String getJwk() {
        return this.jwk;
    }

    @Generated
    public Date getCreated() {
        return this.created;
    }
}

