/*
 * Decompiled with CFR 0.152.
 */
package oidc.security;

import java.util.HashMap;
import java.util.Map;
import oidc.security.UserProvisioning;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class CustomOidcUserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private static final Log LOG = LogFactory.getLog(CustomOidcUserService.class);
    private final OidcUserService delegate = new OidcUserService();
    private final UserProvisioning userProvisioning;

    public CustomOidcUserService(UserProvisioning userProvisioning) {
        this.userProvisioning = userProvisioning;
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser oidcUser = this.delegate.loadUser(userRequest);
        Map claims = oidcUser.getUserInfo().getClaims();
        HashMap newClaims = new HashMap(claims);
        LOG.debug((Object)("Provision oidcUser: " + String.valueOf(claims)));
        this.userProvisioning.provision(oidcUser);
        OidcUserInfo oidcUserInfo = new OidcUserInfo(newClaims);
        oidcUser = new DefaultOidcUser(oidcUser.getAuthorities(), oidcUser.getIdToken(), oidcUserInfo);
        return oidcUser;
    }
}

