/*
 * Decompiled with CFR 0.152.
 */
package pdp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.openaz.xacml.util.FactoryException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import pdp.PolicyViolationRetentionPeriodCleaner;
import pdp.access.BasicAuthenticationManager;
import pdp.access.PolicyIdpAccessEnforcerFilter;
import pdp.policies.DevelopmentPrePolicyLoader;
import pdp.policies.NoopPrePolicyLoader;
import pdp.policies.PerformancePrePolicyLoader;
import pdp.policies.PolicyLoader;
import pdp.repositories.PdpPolicyRepository;
import pdp.repositories.PdpPolicyViolationRepository;
import pdp.sab.SabClient;
import pdp.serviceregistry.ClassPathResourceServiceRegistry;
import pdp.serviceregistry.ServiceRegistry;
import pdp.serviceregistry.UrlResourceServiceRegistry;
import pdp.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import pdp.shibboleth.ShibbolethUserDetailService;
import pdp.shibboleth.mock.MockShibbolethFilter;
import pdp.teams.VootClient;
import pdp.web.CsrfProtectionMatcher;
import pdp.web.CsrfTokenResponseHeaderBindingFilter;
import pdp.xacml.PDPEngineHolder;

@SpringBootApplication
public class PdpApplication {
    @Autowired
    private ResourceLoader resourceLoader;

    public static void main(String[] args) {
        SpringApplication.run(PdpApplication.class, (String[])args);
    }

    @Bean
    @Autowired
    public PDPEngineHolder pdpEngine(@Value(value="${xacml.properties.path}") String xacmlPropertiesFileLocation, PdpPolicyRepository pdpPolicyRepository, VootClient vootClient, SabClient sabClient, PolicyLoader policyLoader) throws IOException, FactoryException {
        Resource resource = this.resourceLoader.getResource(xacmlPropertiesFileLocation);
        String absolutePath = resource.getFile().getAbsolutePath();
        System.setProperty("xacml.properties", absolutePath);
        policyLoader.loadPolicies();
        return new PDPEngineHolder(pdpPolicyRepository, vootClient, sabClient);
    }

    @Bean
    @Profile(value={"dev", "no-csrf"})
    @Autowired
    public PolicyLoader developmentPrePolicyLoader(@Value(value="${policy.base.dir}") String policyBaseDir, PdpPolicyRepository pdpPolicyRepository, PdpPolicyViolationRepository pdpPolicyViolationRepository) {
        return new DevelopmentPrePolicyLoader(this.resourceLoader.getResource(policyBaseDir), pdpPolicyRepository, pdpPolicyViolationRepository);
    }

    @Bean
    @Profile(value={"perf"})
    @Autowired
    public PolicyLoader performancePrePolicyLoader(@Value(value="${performance.pre.policy.loader.count}") int count, ServiceRegistry serviceRegistry, PdpPolicyRepository pdpPolicyRepository, PdpPolicyViolationRepository pdpPolicyViolationRepository) {
        return new PerformancePrePolicyLoader(count, serviceRegistry, pdpPolicyRepository, pdpPolicyViolationRepository);
    }

    @Bean
    @Profile(value={"test", "acc", "prod"})
    public PolicyLoader noopPolicyLoader() {
        return new NoopPrePolicyLoader();
    }

    @Bean
    @Profile(value={"!prod"})
    public ServiceRegistry classPathResourceServiceRegistry() {
        return new ClassPathResourceServiceRegistry(true);
    }

    @Bean
    @Profile(value={"prod"})
    public ServiceRegistry urlResourceServiceRegistry(@Value(value="metadata.idpRemotePath") String idpRemotePath, @Value(value="metadata.spRemotePath") String spRemotePath, @Value(value="${period.metadata.refresh.minutes}") int period) {
        return new UrlResourceServiceRegistry(idpRemotePath, spRemotePath, period);
    }

    @Bean
    public PolicyViolationRetentionPeriodCleaner policyViolationRetentionPeriodCleaner(@Value(value="${policy.violation.retention.period.days}") int retentionPeriodDays, PdpPolicyViolationRepository pdpPolicyViolationRepository) {
        return new PolicyViolationRetentionPeriodCleaner(retentionPeriodDays, pdpPolicyViolationRepository);
    }

    @Configuration
    @EnableWebSecurity
    public static class ShibbolethSecurityConfig
    extends WebSecurityConfigurerAdapter {
        @Value(value="${policy.enforcement.point.user.name}")
        private String policyEnforcementPointUserName;
        @Value(value="${policy.enforcement.point.user.password}")
        private String policyEnforcementPointPassword;
        @Autowired
        private ServiceRegistry serviceRegistry;
        @Autowired
        private Environment environment;

        public void configure(WebSecurity web) throws Exception {
            web.ignoring().antMatchers(new String[]{"/health", "/info"});
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER).and()).csrf().requireCsrfProtectionMatcher((RequestMatcher)new CsrfProtectionMatcher()).and()).addFilterAfter((Filter)new CsrfTokenResponseHeaderBindingFilter(), CsrfFilter.class).addFilterBefore((Filter)new PolicyIdpAccessEnforcerFilter(new BasicAuthenticationManager(this.policyEnforcementPointUserName, this.policyEnforcementPointPassword), this.serviceRegistry), AbstractPreAuthenticatedProcessingFilter.class).addFilterAfter((Filter)new ShibbolethPreAuthenticatedProcessingFilter(this.authenticationManagerBean(), this.serviceRegistry), PolicyIdpAccessEnforcerFilter.class).authorizeRequests().antMatchers(new String[]{"/decide/**"})).hasAnyRole(new String[]{"PEP", "ADMIN"}).antMatchers(new String[]{"/internal/**"})).hasAnyRole(new String[]{"PEP", "ADMIN"}).antMatchers(new String[]{"/public/**", "/health/**", "/info/**"})).permitAll().antMatchers(new String[]{"/**"})).hasRole("USER");
            if (this.environment.acceptsProfiles(new String[]{"no-csrf"})) {
                http.csrf().disable();
            }
            if (this.environment.acceptsProfiles(new String[]{"dev", "perf", "no-csrf"})) {
                http.addFilterBefore((Filter)new MockShibbolethFilter(), ShibbolethPreAuthenticatedProcessingFilter.class);
            }
        }

        protected void configure(AuthenticationManagerBuilder auth) throws Exception {
            PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
            authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new ShibbolethUserDetailService());
            auth.authenticationProvider((AuthenticationProvider)authenticationProvider);
        }
    }

    @Configuration
    public static class WebMvcConfig
    extends WebMvcConfigurerAdapter {
        public void addInterceptors(InterceptorRegistry registry) {
            super.addInterceptors(registry);
            registry.addInterceptor((HandlerInterceptor)new HandlerInterceptorAdapter(){

                public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                    response.addHeader("X-SESSION-ALIVE", "true");
                    return true;
                }
            });
        }
    }
}

