/*
 * Decompiled with CFR 0.152.
 */
package pdp.web;

import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;
import pdp.PdpPolicyException;

@RestController
public class ErrorController
implements org.springframework.boot.autoconfigure.web.ErrorController {
    private final ErrorAttributes errorAttributes;

    @Autowired
    public ErrorController(ErrorAttributes errorAttributes) {
        Assert.notNull((Object)errorAttributes, (String)"ErrorAttributes must not be null");
        this.errorAttributes = errorAttributes;
    }

    public String getErrorPath() {
        return "/error";
    }

    @RequestMapping(value={"/error"})
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest aRequest) {
        ResponseStatus annotation;
        ServletRequestAttributes requestAttributes = new ServletRequestAttributes(aRequest);
        Map result = this.errorAttributes.getErrorAttributes((RequestAttributes)requestAttributes, false);
        Throwable error = this.errorAttributes.getError((RequestAttributes)requestAttributes);
        if (error instanceof MethodArgumentNotValidException) {
            BindingResult bindingResult = ((MethodArgumentNotValidException)error).getBindingResult();
            if (bindingResult.hasErrors()) {
                Map<String, String> details = bindingResult.getAllErrors().stream().filter(e -> e instanceof FieldError).map(e -> (FieldError)e).collect(Collectors.toMap(FieldError::getField, DefaultMessageSourceResolvable::getDefaultMessage));
                result.put("details", details);
            }
        } else if (error instanceof PdpPolicyException) {
            PdpPolicyException e2 = (PdpPolicyException)error;
            result.put("details", e2.getDetails());
        }
        if (result.containsKey("details")) {
            result.remove("exception");
            result.remove("message");
        }
        HttpStatus statusCode = error == null ? HttpStatus.INTERNAL_SERVER_ERROR : ((annotation = (ResponseStatus)AnnotationUtils.getAnnotation(error.getClass(), ResponseStatus.class)) != null ? annotation.value() : HttpStatus.INTERNAL_SERVER_ERROR);
        return new ResponseEntity((Object)result, statusCode);
    }
}

