/*
 * Decompiled with CFR 0.152.
 */
package pdp.xacml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.pdp.policy.AdviceExpression;
import org.apache.openaz.xacml.pdp.policy.AnyOf;
import org.apache.openaz.xacml.pdp.policy.AttributeAssignmentExpression;
import org.apache.openaz.xacml.pdp.policy.Match;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.Rule;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicyDef;
import org.apache.openaz.xacml.pdp.policy.expressions.AttributeDesignator;
import org.apache.openaz.xacml.pdp.policy.expressions.AttributeValueExpression;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import pdp.domain.PdpAttribute;
import pdp.domain.PdpPolicy;
import pdp.domain.PdpPolicyDefinition;
import pdp.util.StreamUtils;
import pdp.xacml.PdpParseException;

public class PdpPolicyDefinitionParser {
    public static final String SP_ENTITY_ID = "SPentityID";
    public static final String IDP_ENTITY_ID = "IDPentityID";
    public static final String NAME_ID = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";

    public PdpPolicyDefinition parse(PdpPolicy pdpPolicy) {
        PdpPolicyDefinition definition = new PdpPolicyDefinition();
        String policyXml = pdpPolicy.getPolicyXml();
        Policy policy = this.parsePolicy(policyXml);
        definition.setId(pdpPolicy.getId());
        definition.setName(pdpPolicy.getName());
        definition.setDescription(policy.getDescription());
        definition.setCreated(pdpPolicy.getCreated());
        definition.setUserDisplayName(pdpPolicy.getUserDisplayName());
        definition.setRevisionNbr(pdpPolicy.getRevisionNbr());
        definition.setActive(pdpPolicy.isActive());
        this.parseTargets(policyXml, definition, policy);
        List<Rule> rules = StreamUtils.iteratorToList(policy.getRules());
        definition.setDenyRule(!this.isPermitRule(policyXml, rules));
        this.parsePermit(policyXml, definition, rules);
        this.parseDeny(policyXml, definition, rules);
        Collections.sort(definition.getAttributes(), (a1, a2) -> a1.getName().compareTo(a2.getName()));
        return definition;
    }

    private void parseDeny(String policyXml, PdpPolicyDefinition definition, List<Rule> rules) {
        Rule denyRule = this.getRule(rules, Decision.DENY);
        this.parseAdviceExpression(definition, denyRule);
        if (!definition.isDenyRule()) {
            return;
        }
        this.parseAttributes(definition, denyRule, Decision.DENY);
    }

    private void parsePermit(String policyXml, PdpPolicyDefinition definition, List<Rule> rules) {
        if (definition.isDenyRule()) {
            return;
        }
        Rule permitRule = this.getRule(rules, Decision.PERMIT);
        this.parseAttributes(definition, permitRule, Decision.PERMIT);
    }

    private boolean isPermitRule(String policyXml, List<Rule> rules) {
        Rule rule = this.getRule(rules, Decision.PERMIT);
        return rule.getTarget().getAnyOfs() != null;
    }

    private Rule getRule(List<Rule> rules, Decision decision) {
        return (Rule)rules.stream().filter(r -> r.getRuleEffect().getDecision().equals((Object)decision)).collect(StreamUtils.singletonCollector());
    }

    private void parseAttributes(PdpPolicyDefinition definition, Rule rule, Decision decision) {
        List anyOfs = StreamUtils.iteratorToList(rule.getTarget().getAnyOfs());
        if (anyOfs.size() > 1) {
            definition.setAllAttributesMustMatch(true);
        }
        List allOfs = anyOfs.stream().map(anyOf -> StreamUtils.iteratorToList(anyOf.getAllOfs())).flatMap(allOf -> allOf.stream()).collect(Collectors.toList());
        List matches = allOfs.stream().map(allOf -> StreamUtils.iteratorToList(allOf.getMatches())).flatMap(m -> m.stream()).collect(Collectors.toList());
        List<PdpAttribute> pdpAttributes = matches.stream().map(match -> {
            String attributeName = ((AttributeDesignator)match.getAttributeRetrievalBase()).getAttributeId().getUri().toString();
            String attributeValue = (String)match.getAttributeValue().getValue();
            return new PdpAttribute(attributeName, attributeValue);
        }).collect(Collectors.toList());
        definition.setAttributes(pdpAttributes);
    }

    private void parseTargets(String policyXml, PdpPolicyDefinition definition, Policy policy) {
        List<AnyOf> targetAnyOfs = StreamUtils.iteratorToList(policy.getTarget().getAnyOfs());
        targetAnyOfs.forEach(anyOf -> {
            List targetAllOfs = StreamUtils.iteratorToList(anyOf.getAllOfs());
            List targetMatches = targetAllOfs.stream().map(allOf -> StreamUtils.iteratorToList(allOf.getMatches())).flatMap(Collection::stream).collect(Collectors.toList());
            Optional<Match> spEntityID = targetMatches.stream().filter(match -> ((AttributeDesignator)match.getAttributeRetrievalBase()).getAttributeId().getUri().toString().equalsIgnoreCase(SP_ENTITY_ID)).findFirst();
            if (spEntityID.isPresent()) {
                definition.setServiceProviderId((String)spEntityID.get().getAttributeValue().getValue());
            }
            List<String> idpEntityIDs = targetMatches.stream().filter(match -> ((AttributeDesignator)match.getAttributeRetrievalBase()).getAttributeId().getUri().toString().equalsIgnoreCase(IDP_ENTITY_ID)).map(match -> (String)match.getAttributeValue().getValue()).collect(Collectors.toList());
            definition.setIdentityProviderIds(idpEntityIDs);
        });
        if (definition.getServiceProviderId() == null) {
            throw new PdpParseException("SPentityID is required " + policyXml);
        }
    }

    private void parseAdviceExpression(PdpPolicyDefinition definition, Rule denyRule) {
        AdviceExpression adviceExpression = (AdviceExpression)StreamUtils.iteratorToList(denyRule.getAdviceExpressions()).stream().collect(StreamUtils.singletonCollector());
        List<AttributeAssignmentExpression> attributeAssignmentExpressions = StreamUtils.iteratorToList(adviceExpression.getAttributeAssignmentExpressions());
        String denyMesssageEN = this.extractDenyMessage(attributeAssignmentExpressions, "en");
        String denyMesssageNL = this.extractDenyMessage(attributeAssignmentExpressions, "nl");
        definition.setDenyAdvice(denyMesssageEN);
        definition.setDenyAdviceNl(denyMesssageNL);
    }

    private String extractDenyMessage(List<AttributeAssignmentExpression> attributeAssignmentExpressions, String language) {
        return (String)attributeAssignmentExpressions.stream().filter(ase -> ase.getAttributeId().getUri().toString().equals("DenyMessage:" + language)).map(ase -> (String)((AttributeValueExpression)ase.getExpression()).getAttributeValue().getValue()).collect(StreamUtils.singletonCollector());
    }

    public Policy parsePolicy(String policyXml) {
        String cleanedXml = policyXml.trim().replaceAll("\n", "").replaceAll(" +", " ");
        try {
            return (Policy)DOMPolicyDef.load((InputStream)new ByteArrayInputStream(cleanedXml.getBytes()));
        }
        catch (DOMStructureException e) {
            throw new RuntimeException(e);
        }
    }
}

