/*
 * Decompiled with CFR 0.152.
 */
package pdp.serviceregistry;

import java.net.MalformedURLException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import pdp.serviceregistry.ClassPathResourceServiceRegistry;

public class UrlResourceServiceRegistry
extends ClassPathResourceServiceRegistry {
    private final String idpRemotePath;
    private final String spRemotePath;
    private final RestTemplate restTemplate = new RestTemplate();
    private final int period;

    public UrlResourceServiceRegistry(String idpRemotePath, String spRemotePath, int period) {
        super(false);
        this.idpRemotePath = idpRemotePath;
        this.spRemotePath = spRemotePath;
        this.period = period;
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> this.initializeMetadata(), period, period, TimeUnit.MINUTES);
        super.initializeMetadata();
    }

    @Override
    protected List<Resource> getIdpResources() {
        LOG.debug("Fetching IDP metadata entries from {}", (Object)this.idpRemotePath);
        return Arrays.asList(this.getResource(this.idpRemotePath));
    }

    @Override
    protected List<Resource> getSpResources() {
        LOG.debug("Fetching SP metadata entries from {}", (Object)this.spRemotePath);
        return Arrays.asList(this.getResource(this.spRemotePath));
    }

    @Override
    protected void initializeMetadata() {
        HttpHeaders headers = new HttpHeaders();
        String modifiedSinceLastCall = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT")).minusMinutes(this.period));
        headers.set("If-Modified-Since", modifiedSinceLastCall);
        ResponseEntity result = this.restTemplate.exchange(this.idpRemotePath, HttpMethod.HEAD, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        if (!result.getStatusCode().equals((Object)HttpStatus.NOT_MODIFIED)) {
            super.initializeMetadata();
        }
    }

    private Resource getResource(String path) {
        try {
            return new UrlResource(path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

