/*
 * Decompiled with CFR 0.152.
 */
package pdp.xacml;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.openaz.xacml.api.AttributeCategory;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.Response;
import org.apache.openaz.xacml.api.Result;
import org.apache.openaz.xacml.api.pdp.PDPException;
import org.apache.openaz.xacml.api.pdp.ScopeResolver;
import org.apache.openaz.xacml.pdp.OpenAZPDPEngine;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationContextFactory;
import org.apache.openaz.xacml.std.StdMutableResponse;
import org.apache.openaz.xacml.std.StdMutableResult;
import pdp.util.StreamUtils;

public class OpenConextPDPEngine
extends OpenAZPDPEngine {
    private final boolean policyIncludeAggregatedAttributes;
    private static final List<String> includeAggregatedAttributesIdentifiers = Arrays.asList("urn:collab:group:surfteams.nl", "urn:collab:sab:surfnet.nl");

    public OpenConextPDPEngine(boolean policyIncludeAggregatedAttributes, EvaluationContextFactory evaluationContextFactoryIn, Decision defaultDecisionIn, ScopeResolver scopeResolverIn) {
        super(evaluationContextFactoryIn, defaultDecisionIn, scopeResolverIn);
        this.policyIncludeAggregatedAttributes = policyIncludeAggregatedAttributes;
    }

    protected Result processRequest(EvaluationContext evaluationContext) {
        Result result = super.processRequest(evaluationContext);
        String statusMessage = result.getStatus().getStatusMessage();
        if (result.getDecision().equals((Object)Decision.INDETERMINATE) && "No matching root policy found".equals(statusMessage)) {
            StdMutableResult mutableResult = (StdMutableResult)result;
            mutableResult.setDecision(Decision.NOTAPPLICABLE);
        }
        return result;
    }

    public Response decide(Request pepRequest) throws PDPException {
        Response pdpResponse = super.decide(pepRequest);
        pdpResponse = this.includeAggregatedAttributes(pdpResponse);
        return pdpResponse;
    }

    private Response includeAggregatedAttributes(Response pdpResponse) {
        Result result = (Result)pdpResponse.getResults().stream().collect(StreamUtils.singletonCollector());
        StdMutableResult newResult = new StdMutableResult(result.getDecision(), result.getStatus());
        newResult.addObligations(result.getObligations());
        newResult.addAdvice(result.getAssociatedAdvice());
        newResult.addPolicyIdentifiers(result.getPolicyIdentifiers());
        newResult.addPolicySetIdentifiers(result.getPolicySetIdentifiers());
        if (this.policyIncludeAggregatedAttributes && result.getDecision().equals((Object)Decision.PERMIT)) {
            List attributeCategories = result.getAttributes().stream().filter(attrCat -> this.isAddedAttributeCategory((AttributeCategory)attrCat)).distinct().collect(Collectors.toList());
            newResult.addAttributeCategories(attributeCategories);
        }
        return new StdMutableResponse((Result)newResult);
    }

    private boolean isAddedAttributeCategory(AttributeCategory attributeCategory) {
        return includeAggregatedAttributesIdentifiers.contains(attributeCategory.getCategory().getUri().toString());
    }
}

