/*
 * Decompiled with CFR 0.152.
 */
package pdp.xacml;

import org.apache.openaz.xacml.api.pdp.PDPEngine;
import org.apache.openaz.xacml.api.pdp.PDPEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pdp.repositories.PdpPolicyRepository;
import pdp.sab.SabClient;
import pdp.teams.VootClient;
import pdp.xacml.OpenConextPDPEngineFactory;

public class PDPEngineHolder {
    private static Logger LOG = LoggerFactory.getLogger(PDPEngineHolder.class);
    private final SabClient sabClient;
    private PdpPolicyRepository pdpPolicyRepository;
    private VootClient vootClient;

    public PDPEngineHolder(PdpPolicyRepository pdpPolicyRepository, VootClient vootClient, SabClient sabClient) {
        this.pdpPolicyRepository = pdpPolicyRepository;
        this.vootClient = vootClient;
        this.sabClient = sabClient;
    }

    public PDPEngine newPdpEngine(boolean policyIncludeAggregatedAttributes) {
        try {
            PDPEngineFactory factory = PDPEngineFactory.newInstance();
            if (factory instanceof OpenConextPDPEngineFactory) {
                return ((OpenConextPDPEngineFactory)factory).newEngine(policyIncludeAggregatedAttributes, this.pdpPolicyRepository, this.vootClient, this.sabClient);
            }
            return factory.newEngine();
        }
        catch (Exception e) {
            LOG.error("Exception while re-creating PDPEngine", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

