/*
 * Decompiled with CFR 0.152.
 */
package pdp;

import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import pdp.RegExpRequestMatcherFilter;
import pdp.access.BasicAuthenticationManager;
import pdp.access.PolicyIdpAccessEnforcerFilter;
import pdp.serviceregistry.ServiceRegistry;
import pdp.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import pdp.shibboleth.ShibbolethUserDetailService;
import pdp.shibboleth.mock.MockShibbolethFilter;
import pdp.web.CsrfProtectionMatcher;
import pdp.web.CsrfTokenResponseHeaderBindingFilter;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    public static final String NON_SHIBBOLETH_PROTECTED_METHODS = "^(?!/protected/*|/decide/policy|/health|/info).*$";
    @Value(value="${policy.enforcement.point.user.name}")
    private String policyEnforcementPointUserName;
    @Value(value="${policy.enforcement.point.user.password}")
    private String policyEnforcementPointPassword;
    @Autowired
    private ServiceRegistry serviceRegistry;
    @Autowired
    private Environment environment;

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/health/**", "/info/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER).and()).csrf().requireCsrfProtectionMatcher((RequestMatcher)new CsrfProtectionMatcher()).and()).addFilterAfter((Filter)new CsrfTokenResponseHeaderBindingFilter(), CsrfFilter.class).addFilterBefore((Filter)new PolicyIdpAccessEnforcerFilter(new BasicAuthenticationManager(this.policyEnforcementPointUserName, this.policyEnforcementPointPassword), this.serviceRegistry), AbstractPreAuthenticatedProcessingFilter.class).addFilterAfter((Filter)new RegExpRequestMatcherFilter((Filter)new ShibbolethPreAuthenticatedProcessingFilter(this.authenticationManagerBean(), this.serviceRegistry), NON_SHIBBOLETH_PROTECTED_METHODS), PolicyIdpAccessEnforcerFilter.class).authorizeRequests().antMatchers(new String[]{"/protected/**"})).hasAnyRole(new String[]{"PEP", "ADMIN"}).antMatchers(new String[]{"/decide/**"})).hasAnyRole(new String[]{"PEP", "ADMIN"}).antMatchers(new String[]{"/internal/**"})).hasAnyRole(new String[]{"PEP", "ADMIN"}).antMatchers(new String[]{"/public/**", "/health/**", "/info/**"})).permitAll().antMatchers(new String[]{"/**"})).hasRole("USER");
        if (this.environment.acceptsProfiles(new String[]{"no-csrf"})) {
            http.csrf().disable();
        }
        if (this.environment.acceptsProfiles(new String[]{"dev", "perf"})) {
            http.addFilterBefore((Filter)new MockShibbolethFilter(), ShibbolethPreAuthenticatedProcessingFilter.class);
        }
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
        authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new ShibbolethUserDetailService());
        auth.authenticationProvider((AuthenticationProvider)authenticationProvider);
    }
}

