/*
 * Decompiled with CFR 0.152.
 */
package pdp.serviceregistry;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpStatus;

public class BasicAuthenticationUrlResource
extends UrlResource {
    private final String basicAuth;

    public BasicAuthenticationUrlResource(String path, String username, String password) throws MalformedURLException {
        super(path);
        this.basicAuth = "Basic " + new String(Base64.getEncoder().encode((username + ":" + password).getBytes()));
    }

    public InputStream getInputStream() throws IOException {
        URLConnection con = this.getURL().openConnection();
        this.setHeaders(con);
        try {
            return con.getInputStream();
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            throw ex;
        }
    }

    public boolean isModified(int minutes) {
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)this.getURL().openConnection();
            con.setRequestMethod("HEAD");
            this.setHeaders(con);
            String lastRefresh = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT")).minusMinutes(minutes));
            con.setRequestProperty("If-Modified-Since", lastRefresh);
            int responseCode = con.getResponseCode();
            return responseCode != HttpStatus.NOT_MODIFIED.value();
        }
        catch (IOException ex) {
            con.disconnect();
            throw new RuntimeException(ex);
        }
    }

    private void setHeaders(URLConnection con) {
        con.setRequestProperty("Authorization", this.basicAuth);
        con.setRequestProperty("Content-Type", "application/json");
        con.setConnectTimeout(5000);
    }
}

