/*
 * Decompiled with CFR 0.152.
 */
package pdp.web;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import pdp.access.PolicyIdpAccessEnforcer;
import pdp.domain.EntityMetaData;
import pdp.serviceregistry.ServiceRegistry;

@RestController
@RequestMapping(headers={"Content-Type=application/json"}, produces={"application/json"})
public class ServiceRegistryController {
    private final ServiceRegistry serviceRegistry;
    private final PolicyIdpAccessEnforcer policyIdpAccessEnforcer;

    @Autowired
    public ServiceRegistryController(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.policyIdpAccessEnforcer = new PolicyIdpAccessEnforcer(serviceRegistry);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/serviceProviders"})
    public List<EntityMetaData> serviceProviders() {
        return this.serviceRegistry.serviceProviders();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/identityProviders"})
    public List<EntityMetaData> identityProviders() {
        return this.serviceRegistry.identityProviders();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/identityProviders/scoped"})
    public List<EntityMetaData> identityProvidersScoped() {
        return this.policyIdpAccessEnforcer.filterIdentityProviders(this.serviceRegistry.identityProviders());
    }
}

