/*
 * Decompiled with CFR 0.152.
 */
package pdp.shibboleth.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.GenericFilterBean;

public class MockShibbolethFilter
extends GenericFilterBean {
    private static final Logger LOG = LoggerFactory.getLogger(MockShibbolethFilter.class);

    public MockShibbolethFilter() {
        LOG.info("MockShibbolethFilter initializing...");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        SetHeader wrapper = new SetHeader((HttpServletRequest)servletRequest);
        wrapper.setHeader("uid", "urn:collab:person:example.com:admin");
        wrapper.setHeader("Shib-Authenticating-Authority", "http://mock-idp");
        wrapper.setHeader("displayname", "John Doe");
        filterChain.doFilter((ServletRequest)wrapper, servletResponse);
    }

    private static class SetHeader
    extends HttpServletRequestWrapper {
        private final HashMap<String, String> headers = new HashMap();

        public SetHeader(HttpServletRequest request) {
            super(request);
        }

        public void setHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public Enumeration<String> getHeaderNames() {
            ArrayList names = Collections.list(super.getHeaderNames());
            names.addAll(this.headers.keySet());
            return Collections.enumeration(names);
        }

        public String getHeader(String name) {
            if (this.headers.containsKey(name)) {
                return this.headers.get(name);
            }
            return super.getHeader(name);
        }
    }
}

