/*
 * Decompiled with CFR 0.152.
 */
package pdp.serviceregistry;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import pdp.access.PolicyIdpAccessUnknownIdentityProvidersException;
import pdp.domain.EntityMetaData;
import pdp.serviceregistry.ServiceRegistry;
import pdp.util.StreamUtils;

public class ClassPathResourceServiceRegistry
implements ServiceRegistry {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, List<EntityMetaData>> entityMetaData = new HashMap<String, List<EntityMetaData>>();

    public ClassPathResourceServiceRegistry(boolean initialize) {
        if (initialize) {
            this.initializeMetadata();
        }
    }

    protected void initializeMetadata() {
        this.entityMetaData = new HashMap<String, List<EntityMetaData>>();
        try {
            this.entityMetaData.put("IDPentityID", this.parseEntities(this.getIdpResource()));
            this.entityMetaData.put("SPentityID", this.parseEntities(this.getSpResource()));
            this.LOG.debug("Initialized SR Resources. Number of IDPs {}. Number of SPs {}", (Object)this.entityMetaData.get("IDPentityID").size(), (Object)this.entityMetaData.get("SPentityID").size());
        }
        catch (RuntimeException e) {
            this.LOG.error("Error in refreshing / initializing metadata", (Throwable)e);
        }
    }

    protected Resource getIdpResource() {
        return new ClassPathResource("service-registry/identity-providers.json");
    }

    protected Resource getSpResource() {
        return new ClassPathResource("service-registry/service-providers.json");
    }

    @Override
    public List<EntityMetaData> serviceProviders() {
        return this.entityMetaData.get("SPentityID");
    }

    @Override
    public List<EntityMetaData> identityProviders() {
        return this.entityMetaData.get("IDPentityID");
    }

    @Override
    public Set<EntityMetaData> identityProvidersByAuthenticatingAuthority(String authenticatingAuthority) {
        EntityMetaData idp = this.identityProviderByEntityId(authenticatingAuthority);
        String institutionId = idp.getInstitutionId();
        if (StringUtils.hasText((String)institutionId)) {
            return this.identityProviders().stream().filter(md -> institutionId.equals(md.getInstitutionId())).collect(Collectors.toSet());
        }
        return Sets.newHashSet((Object[])new EntityMetaData[]{idp});
    }

    @Override
    public Set<EntityMetaData> serviceProvidersByInstitutionId(String institutionId) {
        if (StringUtils.isEmpty((Object)institutionId)) {
            return Collections.emptySet();
        }
        return this.serviceProviders().stream().filter(sp -> institutionId.equals(sp.getInstitutionId())).collect(Collectors.toSet());
    }

    @Override
    public Optional<EntityMetaData> serviceProviderOptionalByEntityId(String entityId) {
        return this.entityMetaDataOptionalByEntityId(entityId, this.serviceProviders());
    }

    @Override
    public Optional<EntityMetaData> identityProviderOptionalByEntityId(String entityId) {
        return this.entityMetaDataOptionalByEntityId(entityId, this.identityProviders());
    }

    private Optional<EntityMetaData> entityMetaDataOptionalByEntityId(String entityId, List<EntityMetaData> entityMetaDatas) {
        return entityMetaDatas.stream().filter(sp -> sp.getEntityId().equals(entityId)).collect(StreamUtils.singletonOptionalCollector());
    }

    @Override
    public EntityMetaData serviceProviderByEntityId(String entityId) {
        return this.getOptionalEntityMetaData(entityId, this.serviceProviderOptionalByEntityId(entityId));
    }

    @Override
    public EntityMetaData identityProviderByEntityId(String entityId) {
        return this.getOptionalEntityMetaData(entityId, this.identityProviderOptionalByEntityId(entityId));
    }

    @Override
    public List<String> identityProviderNames(List<String> entityIds) {
        return this.identityProviders().stream().filter(idp -> entityIds.contains(idp.getEntityId())).map(EntityMetaData::getNameEn).collect(Collectors.toList());
    }

    private EntityMetaData getOptionalEntityMetaData(String entityId, Optional<EntityMetaData> optional) {
        if (!optional.isPresent()) {
            throw new PolicyIdpAccessUnknownIdentityProvidersException(entityId + " is not a valid or known IdP / SP entityId");
        }
        return optional.get();
    }

    protected List<EntityMetaData> parseEntities(Resource resource) {
        try {
            List list = (List)objectMapper.readValue(resource.getInputStream(), List.class);
            return list.stream().map(entry -> new EntityMetaData((String)entry.get("entityid"), (String)entry.get("coin:institution_id"), this.getMetaDateEntry((Map<String, Object>)entry, "description"), this.getMetaDateEntry((Map<String, Object>)entry, "name"), this.getMetaDateEntry((Map<String, Object>)entry, "description"), this.getMetaDateEntry((Map<String, Object>)entry, "name"), this.getPolicyEnforcementDecisionRequired((Map<String, Object>)entry), this.getAllowedAll((Map<String, Object>)entry), this.getAllowedEntries((Map<String, Object>)entry))).sorted(this.sortEntityMetaData()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> getAllowedEntries(Map<String, Object> entry) {
        List allowedEntities = entry.getOrDefault("allowedEntities", Collections.emptyList());
        return new HashSet<String>(allowedEntities);
    }

    private boolean getAllowedAll(Map<String, Object> entry) {
        String allowedall = (String)entry.getOrDefault("allowedall", "yes");
        return allowedall.equals("yes");
    }

    private boolean getPolicyEnforcementDecisionRequired(Map<String, Object> entry) {
        Object policyEnforcementDecisionRequired = entry.get("coin:policy_enforcement_decision_required");
        if (policyEnforcementDecisionRequired != null) {
            if (policyEnforcementDecisionRequired instanceof Boolean) {
                return (Boolean)policyEnforcementDecisionRequired;
            }
            if (policyEnforcementDecisionRequired instanceof String) {
                return policyEnforcementDecisionRequired.equals("1");
            }
        }
        return false;
    }

    private Comparator<? super EntityMetaData> sortEntityMetaData() {
        return (e1, e2) -> this.getEntityMetaDataComparatorId((EntityMetaData)e1).compareTo(this.getEntityMetaDataComparatorId((EntityMetaData)e2));
    }

    private String getEntityMetaDataComparatorId(EntityMetaData metaData) {
        return metaData.getNameEn() != null ? metaData.getNameEn() : (metaData.getNameNl() != null ? metaData.getNameNl() : metaData.getEntityId());
    }

    private String getMetaDateEntry(Map<String, Object> entry, String attributeName) {
        String attribute = (String)entry.get(attributeName + ":en");
        if (!StringUtils.hasText((String)attribute) && !StringUtils.hasText((String)(attribute = (String)entry.get(attributeName + ":nl")))) {
            attribute = (String)entry.get("entityid");
        }
        return attribute;
    }

    public void allowAll(boolean allowAll) {
        this.identityProviders().forEach(md -> this.doAllowAll((EntityMetaData)md, allowAll));
        this.serviceProviders().forEach(md -> this.doAllowAll((EntityMetaData)md, allowAll));
    }

    private void doAllowAll(EntityMetaData md, boolean allowAll) {
        try {
            ReflectionUtils.setField((Field)EntityMetaData.class.getDeclaredField("allowedAll"), (Object)md, (Object)allowAll);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

