/*
 * Decompiled with CFR 0.152.
 */
package pdp;

import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.openaz.xacml.util.FactoryException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricFilterAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.TraceWebFilterAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import pdp.PolicyViolationRetentionPeriodCleaner;
import pdp.policies.DevelopmentPrePolicyLoader;
import pdp.policies.NoopPrePolicyLoader;
import pdp.policies.PerformancePrePolicyLoader;
import pdp.policies.PolicyLoader;
import pdp.repositories.PdpPolicyRepository;
import pdp.repositories.PdpPolicyViolationRepository;
import pdp.sab.SabClient;
import pdp.serviceregistry.ClassPathResourceServiceRegistry;
import pdp.serviceregistry.ServiceRegistry;
import pdp.serviceregistry.UrlResourceServiceRegistry;
import pdp.teams.VootClient;
import pdp.web.SessionAliveInterceptor;
import pdp.xacml.PDPEngineHolder;

@SpringBootApplication(exclude={ManagementWebSecurityAutoConfiguration.class, SecurityAutoConfiguration.class, TraceWebFilterAutoConfiguration.class, MetricFilterAutoConfiguration.class})
public class PdpApplication {
    @Autowired
    private ResourceLoader resourceLoader;

    public static void main(String[] args) {
        SpringApplication.run(PdpApplication.class, (String[])args);
    }

    @Bean
    public PDPEngineHolder pdpEngine(@Value(value="${xacml.properties.path}") String xacmlPropertiesFileLocation, PdpPolicyRepository pdpPolicyRepository, VootClient vootClient, SabClient sabClient, PolicyLoader policyLoader) throws IOException, FactoryException {
        Resource resource = this.resourceLoader.getResource(xacmlPropertiesFileLocation);
        String absolutePath = resource.getFile().getAbsolutePath();
        System.setProperty("xacml.properties", absolutePath);
        policyLoader.loadPolicies();
        return new PDPEngineHolder(pdpPolicyRepository, vootClient, sabClient);
    }

    @Bean
    @Profile(value={"dev", "no-csrf"})
    public PolicyLoader developmentPrePolicyLoader(@Value(value="${policy.base.dir}") String policyBaseDir, PdpPolicyRepository pdpPolicyRepository, PdpPolicyViolationRepository pdpPolicyViolationRepository) {
        return new DevelopmentPrePolicyLoader(this.resourceLoader.getResource(policyBaseDir), pdpPolicyRepository, pdpPolicyViolationRepository);
    }

    @Bean
    @Profile(value={"perf"})
    public PolicyLoader performancePrePolicyLoader(@Value(value="${performance.pre.policy.loader.count}") int count, ServiceRegistry serviceRegistry, PdpPolicyRepository pdpPolicyRepository, PdpPolicyViolationRepository pdpPolicyViolationRepository) {
        return new PerformancePrePolicyLoader(count, serviceRegistry, pdpPolicyRepository, pdpPolicyViolationRepository);
    }

    @Bean
    @Profile(value={"test", "acc", "prod"})
    public PolicyLoader noopPolicyLoader() {
        return new NoopPrePolicyLoader();
    }

    @Bean
    @Profile(value={"dev", "no-csrf"})
    public ServiceRegistry classPathResourceServiceRegistry() {
        return new ClassPathResourceServiceRegistry(true);
    }

    @Bean
    @Profile(value={"test", "acc", "prod"})
    public ServiceRegistry urlResourceServiceRegistry(@Value(value="${metadata.username}") String username, @Value(value="${metadata.password}") String password, @Value(value="${metadata.idpRemotePath}") String idpRemotePath, @Value(value="${metadata.spRemotePath}") String spRemotePath, @Value(value="${period.metadata.refresh.minutes}") int period) throws MalformedURLException {
        return new UrlResourceServiceRegistry(username, password, idpRemotePath, spRemotePath, period);
    }

    @Bean
    public PolicyViolationRetentionPeriodCleaner policyViolationRetentionPeriodCleaner(@Value(value="${policy.violation.retention.period.days}") int retentionPeriodDays, PdpPolicyViolationRepository pdpPolicyViolationRepository) {
        return new PolicyViolationRetentionPeriodCleaner(retentionPeriodDays, pdpPolicyViolationRepository);
    }

    @Configuration
    public static class WebMvcConfig
    extends WebMvcConfigurerAdapter {
        public void addInterceptors(InterceptorRegistry registry) {
            super.addInterceptors(registry);
            registry.addInterceptor((HandlerInterceptor)new SessionAliveInterceptor());
        }
    }
}

