/*
 * Decompiled with CFR 0.152.
 */
package pdp.serviceregistry;

import java.net.MalformedURLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.core.io.Resource;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import pdp.serviceregistry.BasicAuthenticationUrlResource;
import pdp.serviceregistry.ClassPathResourceServiceRegistry;

public class UrlResourceServiceRegistry
extends ClassPathResourceServiceRegistry {
    private final String idpRemotePath;
    private final String spRemotePath;
    private final RestTemplate restTemplate = new RestTemplate();
    private final int period;
    private final BasicAuthenticationUrlResource idpUrlResource;
    private final BasicAuthenticationUrlResource spUrlResource;
    private ScheduledFuture<?> scheduledFuture;
    private boolean lastCallFailed = true;

    public UrlResourceServiceRegistry(String username, String password, String idpRemotePath, String spRemotePath, int period) throws MalformedURLException {
        super(false);
        this.idpUrlResource = new BasicAuthenticationUrlResource(idpRemotePath, username, password);
        this.spUrlResource = new BasicAuthenticationUrlResource(spRemotePath, username, password);
        this.idpRemotePath = idpRemotePath;
        this.spRemotePath = spRemotePath;
        this.period = period;
        SimpleClientHttpRequestFactory requestFactory = (SimpleClientHttpRequestFactory)this.restTemplate.getRequestFactory();
        requestFactory.setConnectTimeout(5000);
        this.schedule(period, TimeUnit.MINUTES);
        this.doInitializeMetadata(true);
    }

    private void schedule(int period, TimeUnit timeUnit) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledFuture = Executors.newScheduledThreadPool(1).scheduleAtFixedRate(this::initializeMetadata, period, period, timeUnit);
    }

    @Override
    protected Resource getIdpResource() {
        this.LOG.debug("Fetching IDP metadata entries from {}", (Object)this.idpRemotePath);
        return this.idpUrlResource;
    }

    @Override
    protected Resource getSpResource() {
        this.LOG.debug("Fetching SP metadata entries from {}", (Object)this.spRemotePath);
        return this.spUrlResource;
    }

    private void doInitializeMetadata(boolean forceRefresh) {
        try {
            if (forceRefresh || this.spUrlResource.isModified(this.period) || this.idpUrlResource.isModified(this.period)) {
                super.initializeMetadata();
            } else {
                this.LOG.debug("Not refreshing SP metadata. Not modified");
            }
            if (this.lastCallFailed) {
                this.schedule(this.period, TimeUnit.MINUTES);
            }
            this.lastCallFailed = false;
        }
        catch (Throwable e) {
            this.LOG.error("Error in refreshing / initializing metadata", e);
            this.lastCallFailed = true;
            this.schedule(5, TimeUnit.SECONDS);
        }
    }

    @Override
    protected void initializeMetadata() {
        this.doInitializeMetadata(false);
    }
}

