/*
 * Decompiled with CFR 0.152.
 */
package pdp.web;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletResponse;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.IdReference;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.api.Response;
import org.apache.openaz.xacml.api.Result;
import org.apache.openaz.xacml.api.pdp.PDPEngine;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdAttribute;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdMutableAttribute;
import org.apache.openaz.xacml.std.StdMutableRequest;
import org.apache.openaz.xacml.std.StdMutableRequestAttributes;
import org.apache.openaz.xacml.std.StdRequest;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.json.JSONRequest;
import org.apache.openaz.xacml.std.json.JSONResponse;
import org.apache.openaz.xacml.util.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.support.TaskUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pdp.JsonMapper;
import pdp.PdpPolicyException;
import pdp.PolicyNotFoundException;
import pdp.access.PolicyAccess;
import pdp.access.PolicyIdpAccessEnforcer;
import pdp.conflicts.PolicyConflictService;
import pdp.domain.EntityMetaData;
import pdp.domain.JsonPolicyRequest;
import pdp.domain.PdpPolicy;
import pdp.domain.PdpPolicyDefinition;
import pdp.domain.PdpPolicyViolation;
import pdp.mail.MailBox;
import pdp.policies.PolicyMissingServiceProviderValidator;
import pdp.repositories.PdpPolicyRepository;
import pdp.repositories.PdpPolicyViolationRepository;
import pdp.serviceregistry.ServiceRegistry;
import pdp.stats.StatsContext;
import pdp.stats.StatsContextHolder;
import pdp.util.StreamUtils;
import pdp.web.IPAddressProvider;
import pdp.xacml.PDPEngineHolder;
import pdp.xacml.PdpPolicyDefinitionParser;
import pdp.xacml.PolicyTemplateEngine;

@RestController
@RequestMapping(headers={"Content-Type=application/json"}, produces={"application/json"})
public class PdpController
implements JsonMapper,
IPAddressProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PdpController.class);
    private final PDPEngineHolder pdpEngineHolder;
    private final PdpPolicyViolationRepository pdpPolicyViolationRepository;
    private final PdpPolicyRepository pdpPolicyRepository;
    private final PolicyTemplateEngine policyTemplateEngine = new PolicyTemplateEngine();
    private final PdpPolicyDefinitionParser pdpPolicyDefinitionParser = new PdpPolicyDefinitionParser();
    private final PolicyConflictService policyConflictService = new PolicyConflictService();
    private final ServiceRegistry serviceRegistry;
    private final PolicyIdpAccessEnforcer policyIdpAccessEnforcer;
    private final PDPEngine playgroundPdpEngine;
    private final boolean cachePolicies;
    private final MailBox mailBox;
    private final PolicyMissingServiceProviderValidator policyMissingServiceProviderValidator;
    private final List<String> loaLevels;
    private volatile PDPEngine pdpEngine;

    @Autowired
    public PdpController(@Value(value="${period.policies.refresh.minutes}") int period, @Value(value="${policies.cachePolicies}") boolean cachePolicies, @Value(value="${loa.levels}") String loaLevelsCommaSeparated, PdpPolicyViolationRepository pdpPolicyViolationRepository, PdpPolicyRepository pdpPolicyRepository, PDPEngineHolder pdpEngineHolder, ServiceRegistry serviceRegistry, MailBox mailBox, PolicyMissingServiceProviderValidator policyMissingServiceProviderValidator) {
        this.cachePolicies = cachePolicies;
        this.loaLevels = Stream.of(loaLevelsCommaSeparated.split(",")).map(String::trim).collect(Collectors.toList());
        this.pdpEngineHolder = pdpEngineHolder;
        this.playgroundPdpEngine = pdpEngineHolder.newPdpEngine(false, true);
        this.pdpEngine = pdpEngineHolder.newPdpEngine(cachePolicies, false);
        this.pdpPolicyViolationRepository = pdpPolicyViolationRepository;
        this.policyIdpAccessEnforcer = new PolicyIdpAccessEnforcer(serviceRegistry);
        this.pdpPolicyRepository = pdpPolicyRepository;
        this.serviceRegistry = serviceRegistry;
        this.mailBox = mailBox;
        this.policyMissingServiceProviderValidator = policyMissingServiceProviderValidator;
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate((Runnable)TaskUtils.decorateTaskWithErrorHandler(() -> this.refreshPolicies(), t -> LOG.error("Exception in refreshPolicies task", t), (boolean)true), period, period, TimeUnit.MINUTES);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/decide/policy"})
    public String decide(@RequestBody String payload) throws Exception {
        return this.doDecide(payload, false);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/internal/decide/policy"})
    public String decideInternal(@RequestBody String payload) throws Exception {
        this.refreshPolicies();
        return this.doDecide(payload, true);
    }

    private String doDecide(String payload, boolean isPlayground) throws Exception {
        StatsContext stats = StatsContextHolder.getContext();
        long start = System.currentTimeMillis();
        LOG.debug("decide request: {}", (Object)payload);
        Request request = JSONRequest.load((String)payload);
        this.addStatsDetails(stats, request);
        this.returnPolicyIdInList(request);
        Response pdpResponse = isPlayground ? this.playgroundPdpEngine.decide(request) : this.pdpEngine.decide(request);
        String response = JSONResponse.toString((Response)pdpResponse, (boolean)LOG.isDebugEnabled());
        long took = System.currentTimeMillis() - start;
        stats.setResponseTimeMs(took);
        LOG.debug("decide response: {} took: {} ms", (Object)response, (Object)took);
        this.reportPossiblePolicyViolation(pdpResponse, response, payload, isPlayground);
        this.provideStatsContext(stats, pdpResponse);
        return response;
    }

    private void returnPolicyIdInList(Request request) {
        StdRequest.class.cast(request);
        Field field = ReflectionUtils.findField(Wrapper.class, (String)"wrappedObject");
        ReflectionUtils.makeAccessible((Field)field);
        StdMutableRequest mutableRequest = (StdMutableRequest)StdMutableRequest.class.cast(ReflectionUtils.getField((Field)field, (Object)request));
        mutableRequest.setReturnPolicyIdList(true);
        StdMutableRequestAttributes requestAttributes = (StdMutableRequestAttributes)mutableRequest.getRequestAttributes().stream().filter(requestAttribute -> requestAttribute.getCategory().getUri().toString().equals("urn:oasis:names:tc:xacml:3.0:attribute-category:resource")).findFirst().get();
        Collection attributes = requestAttributes.getAttributes();
        boolean clientIDPresent = attributes.stream().anyMatch(attribute -> attribute.getAttributeId().getUri().toString().equals("ClientID"));
        if (!clientIDPresent) {
            requestAttributes.add((Attribute)new StdAttribute((Attribute)new StdMutableAttribute((Identifier)new IdentifierImpl("urn:oasis:names:tc:xacml:3.0:attribute-category:resource"), (Identifier)new IdentifierImpl("ClientID"), (AttributeValue)new StdAttributeValue((Identifier)new IdentifierImpl("http://www.w3.org/2001/XMLSchema#string"), (Object)"EngineBlock"))));
        }
    }

    private void provideStatsContext(StatsContext stats, Response pdpResponse) {
        Result result = (Result)pdpResponse.getResults().iterator().next();
        stats.setDecision(result.getDecision().toString());
        Optional optionalLoa = this.getOptionalLoa(pdpResponse);
        optionalLoa.ifPresent(loa -> stats.setLoa(loa));
        Optional optionalPolicyId = this.getPolicyId(result);
        optionalPolicyId.ifPresent(policyId -> stats.setPolicyId(policyId.getId().getUri().toString()));
    }

    @RequestMapping(method={RequestMethod.OPTIONS}, value={"/protected/policies"})
    public ResponseEntity<Void> options(HttpServletResponse response) {
        response.setHeader("Allow", Joiner.on((String)",").join((Iterable)ImmutableList.of((Object)RequestMethod.GET, (Object)RequestMethod.POST, (Object)RequestMethod.PUT, (Object)RequestMethod.DELETE)));
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/policies", "/protected/policies"})
    public List<PdpPolicyDefinition> policyDefinitions() {
        Stream<PdpPolicy> stream = StreamSupport.stream(this.pdpPolicyRepository.findAll().spliterator(), false);
        List<PdpPolicyDefinition> policies = stream.map(policy -> this.policyMissingServiceProviderValidator.addEntityMetaData(this.addAccessRules(policy, this.pdpPolicyDefinitionParser.parse(policy)))).collect(Collectors.toList());
        policies = policies.stream().filter(policy -> !policy.isServiceProviderInvalidOrMissing()).collect(Collectors.toList());
        List countPerPolicyId = this.pdpPolicyViolationRepository.findCountPerPolicyId();
        Map<Long, Long> countPerPolicyIdMap = countPerPolicyId.stream().collect(Collectors.toMap(obj -> (Long)obj[0], obj -> (Long)obj[1]));
        policies.forEach(policy -> policy.setNumberOfViolations(countPerPolicyIdMap.getOrDefault(policy.getId(), 0L).intValue()));
        List revisionCountPerId = this.pdpPolicyRepository.findRevisionCountPerId();
        Map<Number, Number> revisionCountPerIdMap = revisionCountPerId.stream().collect(Collectors.toMap(obj -> (Number)obj[0], obj -> (Number)obj[1]));
        policies.forEach(policy -> policy.setNumberOfRevisions(((Number)revisionCountPerIdMap.getOrDefault(policy.getId().intValue(), 0)).intValue()));
        return this.policyIdpAccessEnforcer.filterPdpPolicies(policies);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/conflicts", "/protected/conflicts"})
    public Map<String, List<PdpPolicyDefinition>> conflicts() {
        List policies = StreamSupport.stream(this.pdpPolicyRepository.findAll().spliterator(), false).map(policy -> this.policyMissingServiceProviderValidator.addEntityMetaData(this.pdpPolicyDefinitionParser.parse(policy))).collect(Collectors.toList());
        Map conflicts = this.policyConflictService.conflicts(policies);
        List invalid = policies.stream().filter(policy -> policy.isServiceProviderInvalidOrMissing()).collect(Collectors.toList());
        if (!invalid.isEmpty()) {
            conflicts.put("Invalid", invalid);
        }
        return conflicts;
    }

    @RequestMapping(method={RequestMethod.PUT, RequestMethod.POST}, value={"/internal/policies", "/protected/policies"})
    public PdpPolicy createPdpPolicy(@RequestBody PdpPolicyDefinition pdpPolicyDefinition) throws DOMStructureException {
        PdpPolicy policy;
        String policyXml = this.policyTemplateEngine.createPolicyXml(pdpPolicyDefinition);
        Policy parsedPolicy = this.pdpPolicyDefinitionParser.parsePolicy(policyXml);
        Assert.notNull((Object)parsedPolicy, (String)"ParsedPolicy is not valid");
        if (pdpPolicyDefinition.getId() != null) {
            PdpPolicy fromDB = this.findPolicyById(pdpPolicyDefinition.getId(), PolicyAccess.WRITE);
            policy = fromDB.getParentPolicy() != null ? fromDB.getParentPolicy() : fromDB;
            PdpPolicy.revision((String)pdpPolicyDefinition.getName(), (PdpPolicy)policy, (String)policyXml, (String)this.policyIdpAccessEnforcer.username(), (String)this.policyIdpAccessEnforcer.authenticatingAuthority(), (String)this.policyIdpAccessEnforcer.userDisplayName(), (boolean)pdpPolicyDefinition.isActive());
        } else {
            policy = new PdpPolicy(policyXml, pdpPolicyDefinition.getName(), true, this.policyIdpAccessEnforcer.username(), this.policyIdpAccessEnforcer.authenticatingAuthority(), this.policyIdpAccessEnforcer.userDisplayName(), pdpPolicyDefinition.isActive(), pdpPolicyDefinition.getType());
            this.policyIdpAccessEnforcer.actionAllowed(policy, PolicyAccess.WRITE, pdpPolicyDefinition.getServiceProviderId(), pdpPolicyDefinition.getIdentityProviderIds());
        }
        try {
            PdpPolicy saved = (PdpPolicy)this.pdpPolicyRepository.save((Object)policy);
            LOG.info("{} PdpPolicy {}", (Object)(policy.getId() != null ? "Updated" : "Created"), (Object)saved.getPolicyXml());
            this.checkConflicts(pdpPolicyDefinition);
            return saved;
        }
        catch (DataIntegrityViolationException e) {
            if (e.getMessage().contains("pdp_policy_name_revision_unique")) {
                throw new PdpPolicyException(new String[]{"name", "Policy name must be unique. " + pdpPolicyDefinition.getName() + " is already taken"});
            }
            throw e;
        }
    }

    private void checkConflicts(PdpPolicyDefinition pdpPolicyDefinition) {
        Map conflicts = this.conflicts();
        Optional entityMetaData = this.serviceRegistry.serviceProviderOptionalByEntityId(pdpPolicyDefinition.getServiceProviderId());
        if (entityMetaData.isPresent() && conflicts.containsKey(((EntityMetaData)entityMetaData.get()).getNameEn())) {
            this.mailBox.sendConflictsMail(conflicts);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/policies/{id}", "/protected/policies/{id}"})
    public PdpPolicyDefinition policyDefinition(@PathVariable Long id) {
        PdpPolicyDefinition policyDefinition = this.pdpPolicyDefinitionParser.parse(this.findPolicyById(id, PolicyAccess.READ));
        if ((policyDefinition = this.policyMissingServiceProviderValidator.addEntityMetaData(policyDefinition)).getType().equals("step")) {
            policyDefinition.getLoas().forEach(loa -> loa.getCidrNotations().forEach(notation -> notation.setIpInfo(this.getIpInfo(notation.getIpAddress(), Integer.valueOf(notation.getPrefix())))));
        }
        return policyDefinition;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/internal/policies/{id}", "/protected/policies/{id}"})
    public void deletePdpPolicy(@PathVariable Long id) throws DOMStructureException {
        PdpPolicy policy = this.findPolicyById(id, PolicyAccess.WRITE);
        LOG.info("Deleting PdpPolicy {}", (Object)policy.getName());
        policy = policy.getParentPolicy() != null ? policy.getParentPolicy() : policy;
        this.pdpPolicyRepository.delete((Object)policy);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/default-policy/{type}"})
    public PdpPolicyDefinition defaultPolicy(@PathVariable String type) {
        PdpPolicyDefinition pdpPolicyDefinition = new PdpPolicyDefinition();
        pdpPolicyDefinition.setType(type);
        return pdpPolicyDefinition;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/policies/sp"})
    public List<PdpPolicyDefinition> policyDefinitionsByServiceProvider(@RequestParam String serviceProvider) {
        List policies = this.policyDefinitions();
        List filterBySp = StreamSupport.stream(policies.spliterator(), false).filter(policy -> policy.getServiceProviderId().equals(serviceProvider)).collect(Collectors.toList());
        return this.policyIdpAccessEnforcer.filterPdpPolicies(filterBySp);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/violations"})
    public Iterable<PdpPolicyViolation> violations() {
        Iterable violations = this.pdpPolicyViolationRepository.findAll();
        return this.policyIdpAccessEnforcer.filterViolations(violations);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/violations/{id}"})
    public Iterable<PdpPolicyViolation> violationsByPolicyId(@PathVariable Long id) {
        Set violations = this.findPolicyById(id, PolicyAccess.VIOLATIONS).getViolations();
        return this.policyIdpAccessEnforcer.filterViolations((Iterable)violations);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/revisions/{id}", "/protected/revisions/{id}"})
    public List<PdpPolicyDefinition> revisionsByPolicyId(@PathVariable Long id) {
        PdpPolicy policy = this.findPolicyById(id, PolicyAccess.READ);
        PdpPolicy parent = policy.getParentPolicy() != null ? policy.getParentPolicy() : policy;
        Set policies = parent.getRevisions();
        policies.add(parent);
        return policies.stream().map(rev -> this.policyMissingServiceProviderValidator.addEntityMetaData(this.addAccessRules(rev, this.pdpPolicyDefinitionParser.parse(rev)))).collect(Collectors.toList());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/loas", "/protected/loas"})
    public List<String> allowedLevelOfAssurances() throws IOException {
        return this.loaLevels;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/attributes", "/protected/attributes"})
    public List<JsonPolicyRequest.Attribute> allowedAttributes() throws IOException {
        InputStream inputStream = new ClassPathResource("xacml/attributes/allowed_attributes.json").getInputStream();
        CollectionType type = objectMapper.getTypeFactory().constructCollectionType(List.class, JsonPolicyRequest.Attribute.class);
        return (List)objectMapper.readValue(inputStream, (JavaType)type);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/saml-attributes"})
    public List<JsonPolicyRequest.Attribute> allowedSamlAttributes() throws IOException {
        InputStream inputStream = new ClassPathResource("xacml/attributes/extra_saml_attributes.json").getInputStream();
        CollectionType type = objectMapper.getTypeFactory().constructCollectionType(List.class, JsonPolicyRequest.Attribute.class);
        List attributes = (List)objectMapper.readValue(inputStream, (JavaType)type);
        attributes.addAll(this.allowedAttributes());
        return attributes;
    }

    private PdpPolicy findPolicyById(Long id, PolicyAccess policyAccess) {
        PdpPolicy policy = (PdpPolicy)this.pdpPolicyRepository.findOne((Serializable)id);
        if (policy == null) {
            throw new PolicyNotFoundException("PdpPolicy with id " + id + " not found");
        }
        PdpPolicyDefinition definition = this.pdpPolicyDefinitionParser.parse(policy);
        this.policyIdpAccessEnforcer.actionAllowed(policy, policyAccess, definition.getServiceProviderId(), definition.getIdentityProviderIds());
        return policy;
    }

    private PdpPolicyDefinition addAccessRules(PdpPolicy policy, PdpPolicyDefinition pd) {
        boolean actionsAllowed = this.policyIdpAccessEnforcer.actionAllowedIndicator(policy, PolicyAccess.WRITE, pd.getServiceProviderId(), pd.getIdentityProviderIds());
        pd.setActionsAllowed(actionsAllowed);
        pd.setAuthenticatingAuthorityName(this.serviceRegistry.identityProviderByEntityId(policy.getAuthenticatingAuthority()).getNameEn());
        return pd;
    }

    private void addStatsDetails(StatsContext stats, Request request) {
        RequestAttributes req = (RequestAttributes)request.getRequestAttributes().stream().filter(ra -> ra.getCategory().getUri().toString().equals("urn:oasis:names:tc:xacml:3.0:attribute-category:resource")).collect(StreamUtils.singletonCollector());
        Collection attributes = req.getAttributes();
        stats.setIdentityProvider(this.getAttributeValue(attributes, "IDPentityID").orElse(""));
        stats.setServiceProvicer(this.getAttributeValue(attributes, "SPentityID").orElse(""));
    }

    private Optional<String> getAttributeValue(Collection<Attribute> attributes, String attributeId) {
        Optional attribute = (Optional)attributes.stream().filter(attr -> attr.getAttributeId().getUri().toString().equals(attributeId)).collect(StreamUtils.singletonOptionalCollector());
        return attribute.map(attr -> (String)((AttributeValue)attr.getValues().iterator().next()).getValue());
    }

    private void reportPossiblePolicyViolation(Response pdpResponse, String response, String payload, boolean isPlayground) {
        Collection results = pdpResponse.getResults();
        Optional<Result> deniesOrIndeterminate = results.stream().filter(result -> result.getDecision().equals((Object)Decision.DENY) || result.getDecision().equals((Object)Decision.INDETERMINATE)).findAny();
        deniesOrIndeterminate.ifPresent(result -> {
            Optional idReferenceOptional = this.getPolicyId(result);
            idReferenceOptional.ifPresent(idReference -> {
                String policyId = idReference.getId().stringValue();
                Optional policyOptional = this.pdpPolicyRepository.findFirstByPolicyIdAndLatestRevision(policyId, true);
                policyOptional.ifPresent(policy -> this.pdpPolicyViolationRepository.save((Object)new PdpPolicyViolation(policy, payload, response, isPlayground)));
            });
        });
    }

    private Optional<String> getOptionalLoa(Response pdpResponse) {
        return pdpResponse.getResults().stream().map(result -> result.getObligations().stream().map(obligation -> obligation.getAttributeAssignments().stream().map(attributeAssignment -> (String)String.class.cast(attributeAssignment.getAttributeValue().getValue())))).flatMap(Function.identity()).flatMap(Function.identity()).max(Comparator.naturalOrder());
    }

    private Optional<IdReference> getPolicyId(Result deniesOrIndeterminate) {
        Collection policyIdentifiers = deniesOrIndeterminate.getPolicyIdentifiers();
        Collection policySetIdentifiers = deniesOrIndeterminate.getPolicySetIdentifiers();
        return !CollectionUtils.isEmpty((Collection)policyIdentifiers) ? (Optional)policyIdentifiers.stream().collect(StreamUtils.singletonOptionalCollector()) : (Optional)policySetIdentifiers.stream().collect(StreamUtils.singletonOptionalCollector());
    }

    private void refreshPolicies() {
        LOG.info("Starting reloading policies");
        long start = System.currentTimeMillis();
        this.pdpEngine = this.pdpEngineHolder.newPdpEngine(this.cachePolicies, false);
        LOG.info("Finished reloading policies in {} ms", (Object)(System.currentTimeMillis() - start));
    }
}

