/*
 * Decompiled with CFR 0.152.
 */
package pdp.policies;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import pdp.domain.EntityMetaData;
import pdp.domain.PdpAttribute;
import pdp.domain.PdpPolicy;
import pdp.domain.PdpPolicyDefinition;
import pdp.policies.DevelopmentPrePolicyLoader;
import pdp.repositories.PdpPolicyRepository;
import pdp.repositories.PdpPolicyViolationRepository;
import pdp.serviceregistry.ServiceRegistry;
import pdp.xacml.PolicyTemplateEngine;

public class PerformancePrePolicyLoader
extends DevelopmentPrePolicyLoader {
    private final ServiceRegistry serviceRegistry;
    private final PolicyTemplateEngine templateEngine = new PolicyTemplateEngine();
    private final int count;

    public PerformancePrePolicyLoader(int count, ServiceRegistry serviceRegistry, PdpPolicyRepository pdpPolicyRepository, PdpPolicyViolationRepository pdpPolicyViolationRepository) {
        super((Resource)new ByteArrayResource("noop".getBytes()), pdpPolicyRepository, pdpPolicyViolationRepository);
        this.count = count;
        this.serviceRegistry = serviceRegistry;
    }

    public List<PdpPolicy> getPolicies() {
        List sps = this.serviceRegistry.serviceProviders();
        List idps = this.serviceRegistry.identityProviders();
        EntityMetaData idp = (EntityMetaData)idps.get(idps.size() - 1);
        int nbr = this.count == 0 ? sps.size() : this.count;
        return sps.subList(0, nbr).stream().map(sp -> this.pdpPolicyDefinition(sp, idp, UUID.randomUUID().toString())).map(def -> new PdpPolicy(this.templateEngine.createPolicyXml(def), def.getName(), true, "system", "http://mock-idp", "system", true, "reg")).collect(Collectors.toList());
    }

    private PdpPolicyDefinition pdpPolicyDefinition(EntityMetaData sp, EntityMetaData idp, String uuid) {
        PdpPolicyDefinition definition = new PdpPolicyDefinition();
        definition.setName("Performance_Policy_" + uuid);
        definition.setDescription("Performance Policy " + uuid);
        definition.setServiceProviderId(sp.getEntityId());
        definition.setDenyAdvice("Not authorized");
        definition.setDenyAdviceNl("Niet geautoriseerd");
        definition.setDescription("Performance Policy " + uuid);
        definition.setIdentityProviderIds(Arrays.asList(idp.getEntityId()));
        definition.setType("reg");
        List<PdpAttribute> attributes = Arrays.asList(new PdpAttribute("urn:mace:dir:attribute-def:eduPersonAffiliation", "teacher"), new PdpAttribute("urn:mace:dir:attribute-def:eduPersonAffiliation", "staff"), new PdpAttribute("urn:mace:dir:attribute-def:eduPersonEntitlement", "urn:mace:example.org:demoservice:demo-admin"));
        definition.setAttributes(attributes);
        return definition;
    }
}

