/*
 * Decompiled with CFR 0.152.
 */
package pdp.manage;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import pdp.manage.ClassPathResourceManage;

public class UrlResourceManage
extends ClassPathResourceManage
implements HealthIndicator {
    private static final ZoneId GMT = ZoneId.of("GMT");
    private final String manageBaseUrl;
    private final RestTemplate restTemplate = new RestTemplate();
    private final int refreshInMinutes;
    private final HttpHeaders httpHeaders;
    private String body = "{\"REQUESTED_ATTRIBUTES\":[\"metaDataFields.coin:institution_id\", \"metaDataFields.coin:policy_enforcement_decision_required\", \"allowedall\", \"allowedEntities\"]}";
    private ScheduledFuture<?> scheduledFuture;
    private boolean lastCallFailed = true;
    private volatile ZonedDateTime lastRefreshCheck = ZonedDateTime.now(GMT);
    private volatile ZonedDateTime metadataLastUpdated = ZonedDateTime.now(GMT);

    public UrlResourceManage(String username, String password, String manageBaseUrl, int refreshInMinutes) {
        super(false);
        String basicAuth = "Basic " + new String(Base64.getEncoder().encode((username + ":" + password).getBytes()));
        this.manageBaseUrl = manageBaseUrl;
        this.refreshInMinutes = refreshInMinutes;
        this.httpHeaders = new HttpHeaders();
        this.httpHeaders.add("Content-Type", "application/json");
        this.httpHeaders.add("Authorization", basicAuth);
        SimpleClientHttpRequestFactory requestFactory = (SimpleClientHttpRequestFactory)this.restTemplate.getRequestFactory();
        requestFactory.setConnectTimeout(5000);
        this.schedule(this.refreshInMinutes, TimeUnit.MINUTES);
        this.doInitializeMetadata();
    }

    private void schedule(int period, TimeUnit timeUnit) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledFuture = Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> this.initializeMetadata(), period, period, timeUnit);
    }

    protected Resource getIdpResource() {
        this.LOG.debug("Fetching IDP metadata entries from {}", (Object)this.manageBaseUrl);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/saml20_idp", HttpMethod.POST, new HttpEntity((Object)this.body, (MultiValueMap)this.httpHeaders), String.class, new Object[0]);
        return new ByteArrayResource(((String)responseEntity.getBody()).getBytes());
    }

    protected Resource getSpResource() {
        this.LOG.debug("Fetching SP metadata entries from {}", (Object)this.manageBaseUrl);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/saml20_sp", HttpMethod.POST, new HttpEntity((Object)this.body, (MultiValueMap)this.httpHeaders), String.class, new Object[0]);
        return new ByteArrayResource(((String)responseEntity.getBody()).getBytes());
    }

    private void doInitializeMetadata() {
        try {
            this.lastRefreshCheck = ZonedDateTime.now(GMT);
            this.metadataLastUpdated = ZonedDateTime.now(GMT);
            super.initializeMetadata();
            if (this.lastCallFailed) {
                this.schedule(this.refreshInMinutes, TimeUnit.MINUTES);
            }
            this.lastCallFailed = false;
        }
        catch (Throwable e) {
            this.LOG.error("Error in refreshing / initializing metadata", e);
            this.lastCallFailed = true;
            this.schedule(15, TimeUnit.SECONDS);
        }
    }

    protected void initializeMetadata() {
        this.doInitializeMetadata();
    }

    public Health health() {
        Health.Builder healthBuilder = this.lastRefreshCheck.plusMinutes(this.refreshInMinutes + 2).isBefore(ZonedDateTime.now(GMT)) ? Health.down() : Health.up();
        return healthBuilder.withDetail("lastMetaDataRefreshCheck", (Object)this.lastRefreshCheck.format(DateTimeFormatter.ISO_DATE_TIME)).withDetail("serviceProvidersLastUpdated", (Object)this.metadataLastUpdated.format(DateTimeFormatter.ISO_DATE_TIME)).build();
    }
}

